# -----------------------------------------------------------------------------
# (C) Copyright 2009 SafeNet, Inc. All rights reserved
# -----------------------------------------------------------------------------
#
# This batch file compile the applets used for the Sentinel License Monitor and 
# copy the .class and .html files in the .\root folder.

# ****************************************************************************
# Set the JDK_PATH 
# ****************************************************************************

JDK_PATH=/usr/java/jdk1.5.0_18/
OLDPATH=$PATH
PATH=$JDK_PATH/bin:$PATH;
CLASSPATH=.:$CLASSPATH
# *******************************************************
# Build Sentinel License Monitor related files
# *********************************************

#See if the position of .java files has been passed at commandline
if [ $1 ]
then
	LOCATION=$1
fi

if [ "$LOCATION" = "" ]
then
	LOCATION=.
fi

echo $LOCATION
cd $LOCATION
pwd

javac KeyInfoApplet.java
javac LicenseInfoApplet.java
javac XMLParser.java
javac CancelInfoApplet.java
javac AppletResources.java
javac AppletResources_en.java
javac CMd5Chap.java
javac CMessage.java
javac CPasswordDlg.java
javac SublicenseInfoApplet.java

# Creating the directory structure
# The \root folder should be shipped with the server binary.
rm -rf root
rm -rf root/resources
mkdir root
mkdir root/resources

cp *.html root/

cp KeyInfoApplet.class root/KeyInfoApplet.class
cp LabelAdapter.class root/LabelAdapter.class
cp KeysRow.class root/KeysRow.class
cp LicenseInfoApplet.class root/LicenseInfoApplet.class
cp LicenseRow.class root/LicenseRow.class
cp CancelInfoApplet.class root/CancelInfoApplet.class
cp CancelLicenseRow.class root/CancelLicenseRow.class
cp CMd5Chap.class root/CMd5Chap.class
cp CMessage.class root/CMessage.class
cp CPasswordDlg.class root/CPasswordDlg.class
cp XMLParser.class root/XMLParser.class
cp SublicenseInfoApplet.class root/SublicenseInfoApplet.class
cp SublicenseRow.class root/SublicenseRow.class
cp AppletResources.class root/resources/AppletResources.class
cp AppletResources_en.class root/resources/AppletResources_en.class

chmod -R 777 root
PATH=$OLDPATH
pwd
