/***************************************************************************
 * SublicenseInfoApplet.java
 *
 * (C) Copyright 2009 SafeNet, Inc. All rights reserved.
 *
 *
 * Purpose     : To display the sublicense details for a attached key using sublicenseinfo.xml.
 *
 * Refer to the ReadMe.pdf for customize details of Sentinel License Monitor.
 *
 ****************************************************************************/

//imports
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import javax.swing.*;
import java.util.*;
import java.io.*;
import java.net.*;

/**
 *The Applet to display the sublicense information
 */
public class SublicenseInfoApplet  extends Applet implements ActionListener
{
   static public final String SUBLICENSE_INFO_XML_FILE = "sublicenseinfo.xml";
   ResourceBundle resourceBundle;
   boolean   isResourceBundleFound = false;

   JPanel mCenterPanel = new JPanel();
   JPanel mSouthPanel = new JPanel();
   JPanel mNorthPanel = new JPanel();

   JLabel LicLine1Heading = new JLabel();
   JLabel LicAddStaticLabel = new JLabel();
   Label mLicTopHeadingLabel = new Label();
   JLabel LiclblError = new JLabel();
   JTextArea mLicFootNoteLabel = new JTextArea();
   Label mCopyrightLabel = new Label();

   SublicenseRow headingRow = new SublicenseRow();

   String tmpString = new String();
   String xmlBuffer = new String("");
   Vector vLicenseRow = new Vector(2,1);
   Vector tmpVector = new Vector(2,1);

   SublicenseRow kKeysDetails;
   JButton mBack = new JButton();
   GridBagLayout gridBagLayout1 = new GridBagLayout();
   GridBagLayout gridBagLayout2 = new GridBagLayout();
   GridBagLayout gridBagLayout3 = new GridBagLayout();
   GridBagLayout gridBagLayout4 = new GridBagLayout();
   Color lblColor;
   Color borderColor;
   
   //for refresh
   static int count = 0;

   public SublicenseInfoApplet() 
   {
   }

   public void init() 
   {
      try 
      {
         jbInit();
      }
      catch(Exception e) 
      {
         e.printStackTrace();
      }
   }

   /**
    * Method to pad the serial number.
    */
   static public String PadSerialNumber(int input) 
   {
      int width = 8;
      String output = Integer.toHexString(input);
      output = output.toUpperCase();
      
      for (int i = width - output.length(); i > 0; i--) 
      {
         output = "0" + output;
      }
      output = "0x" + output;
      return output;
   }

   /**
    *Function to fill the data into the rows
    */
   private void fillRow(int iNumberOfKeys)
   {
      XMLParser xParser = new XMLParser();
      try
      {
         SublicenseRow tmpLicenseRow = new SublicenseRow();

         tmpVector = xParser.getXMLTagValue(xmlBuffer, "SubLicCellNo");
         for (int k = 0; k < iNumberOfKeys; k++)
         {
            tmpLicenseRow = (SublicenseRow)vLicenseRow.get(k);
            tmpLicenseRow.lblSLCellAddress.setText("0x" +
                  Integer.toHexString(Integer.parseInt(tmpVector.elementAt(k).toString())).toUpperCase());
         }

         tmpVector = xParser.getXMLTagValue(xmlBuffer, "SubLicInUse");
         if (!tmpVector.isEmpty())
         {
            for (int k = 0; k < iNumberOfKeys; k++)
            {
               tmpLicenseRow = (SublicenseRow)vLicenseRow.get(k);
               tmpLicenseRow.lblSLInUse.setText(tmpVector.elementAt(k).toString());
            }
         }

         tmpVector = xParser.getXMLTagValue(xmlBuffer, "SubLicLimit");
         for (int k = 0; k < iNumberOfKeys; k++)
         {
            tmpLicenseRow = (SublicenseRow)vLicenseRow.get(k);
            tmpLicenseRow.lblSLLimit.setText(tmpVector.elementAt(k).toString());
         }

         //Add the keys row panel in the mCenterPanel
         for (int k = 0, j = 1; k < iNumberOfKeys; k++, j++)
         {
            mCenterPanel.add(((SublicenseRow)vLicenseRow.get(k)),
                  new GridBagConstraints(0, j, 1, 1, 1.0, 0.0,
                        GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL,
                        new Insets(0, 0, 0, 0),
                        0,
                        0));

            if ((k == (iNumberOfKeys - 1)) && (iNumberOfKeys < 10))
            {
               mCenterPanel.add(new JPanel(),
                     new GridBagConstraints(0, j, 1, 1, 1.0, 1.0,
                           GridBagConstraints.NORTH,
                           GridBagConstraints.HORIZONTAL,
                           new Insets(0, 0, 0, 0), 0, 0));
            }
         }
      }
      catch (Exception ex)
      {
      }
   }


    //The method is to get the sublicenseinfo.xml file from the server
   void getSublicenseInfoXML_File_from_Server()
   {
      String inputLine = null;
      try
      {
         URL rURL = new URL(getCodeBase() + SublicenseInfoApplet.SUBLICENSE_INFO_XML_FILE);

         BufferedReader in = new BufferedReader(new InputStreamReader(rURL.openStream(), "UTF-8"));

         while ((inputLine = in.readLine()) != null)
         {
            xmlBuffer = xmlBuffer + inputLine;
         }
         in.close();

      }
      catch (Exception ex) 
      {
      }
   }


   /**
    *Applet initialization method
    */
   private void jbInit() throws Exception 
   {
      String LicAddStaticLabelStr = new String();
      String LiclblErrorStr = new String();
      String XMLFileErrorStr = new String();
      try
      {
         if ( System.getProperty("os.name").indexOf("Mac") != -1)
         {
            lblColor = new Color(0,0,90);
            borderColor = new Color(0,0,90);
         }
         else if (( System.getProperty("os.name").indexOf("Vista") != -1) || (System.getProperty("os.name").indexOf("Windows 7") != -1))
         {
            lblColor = new Color(0,0,90);
            borderColor = new Color(0,0,90);
         }
         else
         {
            lblColor = SystemColor.activeCaption;
            borderColor = Color.lightGray;
         }

         resourceBundle = ResourceBundle.getBundle("AppletResources");
         String tt = resourceBundle.getString("mLicTopHeadingLabel");
         isResourceBundleFound = true;
      }
      catch (MissingResourceException e)
      {
         isResourceBundleFound = false;
      }
      catch (NullPointerException en)
      {
         isResourceBundleFound = false;
      }
      //check if the resource bundle is found
      if(isResourceBundleFound == true)
      {
         mLicTopHeadingLabel.setText(resourceBundle.getString("SIlblTitle"));
         LicLine1Heading.setText(resourceBundle.getString("SIlblTip"));
         mCopyrightLabel.setText(resourceBundle.getString("mCopyrightLabel"));
         mBack.setText(resourceBundle.getString("SIlblBack"));
         mLicFootNoteLabel.setText(resourceBundle.getString("SIlblFootTip"));
         
         LicAddStaticLabelStr = resourceBundle.getString("SIlblSerialNumber");
         LiclblErrorStr = resourceBundle.getString("SIstrErrorNoSublicenseInfo");
         XMLFileErrorStr = resourceBundle.getString("SIstrErrorNoFileInfo");
      }
      else
      {
         mLicTopHeadingLabel.setText("Sublicense Usage Information for the Key");
         LicLine1Heading.setText("Following are the sublicense details of each license available with key.");
         mCopyrightLabel.setText("Copyright (c)2009 SafeNet, Inc.");
         mBack.setText("Back");
         mLicFootNoteLabel.setText("* Cannot display sublicense usage information for the clients using Sentinel driver-based access mode (RNBO_SPN_DRIVER), this mode does not require Sentinel Protection Server to access the keys.");
         LicAddStaticLabelStr = "Serial Number: ";
         LiclblErrorStr = "No sublicense details available.";
         XMLFileErrorStr = "Error in downloading the sublicense information file.";
      }

      this.setLayout(gridBagLayout2);
      mNorthPanel.setLayout(gridBagLayout4);
      mLicTopHeadingLabel.setBackground(lblColor);
      mLicTopHeadingLabel.setFont(new java.awt.Font("Serif", 1, 24));
      mLicTopHeadingLabel.setForeground(Color.white);

      LicAddStaticLabel.setBackground(Color.white);
      LicAddStaticLabel.setFont(new java.awt.Font("Serif", 1, 15));
      LicAddStaticLabel.setForeground(lblColor);

      mCenterPanel.setLayout(gridBagLayout3);
      LicLine1Heading.setBackground(Color.white);
      LicLine1Heading.setFont(new java.awt.Font("Serif", 1, 14));
      LicLine1Heading.setForeground(lblColor);


      mLicFootNoteLabel.setLineWrap(true);
      mLicFootNoteLabel.setWrapStyleWord(true);

      mLicFootNoteLabel.setBackground(Color.white);
      mLicFootNoteLabel.setFont(new java.awt.Font("Serif", 0, 14));
      mLicFootNoteLabel.setForeground(new Color(0, 0, 90));
      mLicFootNoteLabel.setEditable(false);
      mLicFootNoteLabel.setMinimumSize(new Dimension(30, 40));
      mLicFootNoteLabel.setMaximumSize(new Dimension(30, 40));
      mLicFootNoteLabel.setPreferredSize(new Dimension(30, 40));

      mCopyrightLabel.setBackground(Color.white);
      mCopyrightLabel.setFont(new java.awt.Font("Serif", 0, 14));
      mCopyrightLabel.setForeground(new Color(0, 0, 90));

      mBack.setMinimumSize(new Dimension(90, 25));
      mBack.setPreferredSize(new Dimension(90, 25));
      mBack.addActionListener(this);

      LiclblError.setBackground(Color.white);
      LiclblError.setFont(new java.awt.Font("Serif", 1, 14));
      LiclblError.setForeground(Color.red);
      LiclblError.setVisible(false);
      this.setBackground(Color.white);
      this.setForeground(Color.white);
      mCenterPanel.setBackground(Color.white);
      mCenterPanel.setForeground(Color.black);
      mSouthPanel.setBackground(Color.white);
      mSouthPanel.setLayout(gridBagLayout1);

      mNorthPanel.setBackground(Color.white);
      JScrollPane mScrollPane = new JScrollPane();
      mScrollPane.setMaximumSize(new Dimension(500, 501));
      mScrollPane.setMinimumSize(new Dimension(500, 501));
      mScrollPane.setPreferredSize(new Dimension(500, 501));

      mCenterPanel.add(headingRow,     new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));

      this.add(mScrollPane,     new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(15, 5, 15, 5), 0, 0));
      mScrollPane.getViewport().add(mCenterPanel, null);
      mScrollPane.setBorder(BorderFactory.createEmptyBorder());
      this.add(mSouthPanel,   new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0
            ,GridBagConstraints.SOUTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
      this.add(mNorthPanel,     new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));

      mNorthPanel.add(mLicTopHeadingLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
      mNorthPanel.add(LicAddStaticLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
      mNorthPanel.add(LicLine1Heading, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
      mNorthPanel.add(LiclblError, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));

      mSouthPanel.add(mLicFootNoteLabel,    new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
      mSouthPanel.add(mCopyrightLabel,    new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
      mSouthPanel.add(mBack,   new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));


      //Request for the sublicenseinfo.xml file to server
      try
      {
         this.getSublicenseInfoXML_File_from_Server();
         count = 0;
         XMLParser xParser = new XMLParser();

         //get the serial number from the sublicenseinfo file to display.
         tmpVector = xParser.getXMLTagValue(xmlBuffer, "SerialNumber");
         String finalSerialNumberToDisplay;

         String strSerialNumber = tmpVector.elementAt(0).toString();

         //get the serial number in decimal
         int iSerialNumber = Integer.parseInt(strSerialNumber);
         //pad the serial number to displays
         strSerialNumber = PadSerialNumber(iSerialNumber);

         finalSerialNumberToDisplay = LicAddStaticLabelStr + strSerialNumber;
         LicAddStaticLabel.setText(finalSerialNumberToDisplay);

         //get the number of sublicense Info in file
         tmpVector = xParser.getXMLTagValue(xmlBuffer, "Sublicense");
         if(tmpVector.isEmpty())
         {
            LiclblError.setText(LiclblErrorStr);
            LiclblError.setVisible(true);
            mCenterPanel.add(new JPanel(),     new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
                  ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
            return;
         }
         //Get the total number of keys
         int iNumberOfKeys = 0;

         iNumberOfKeys = tmpVector.size();

         for (int k = 0; k < iNumberOfKeys; k++)
         {
            kKeysDetails = new SublicenseRow();
            vLicenseRow.add(kKeysDetails);
         }

         fillRow(iNumberOfKeys);

      }
      catch (Exception ex)
      {
         if (xmlBuffer.length() == 0)
         {
            if (count < 5)
            {
               Thread.sleep(500);
               count++;
               getAppletContext().showDocument(getDocumentBase());
               return;
            }
         }

         LiclblError.setText(XMLFileErrorStr);
         LiclblError.setVisible(true);
         mCenterPanel.add(new JPanel(),     new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
               ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));

      }
   }


   //Start the applet
   public void start() 
   {}

   void mBack_actionPerformed(ActionEvent e)
   {
      try
      {
         String inputLine;
         URL codeBase1;
         codeBase1 = getCodeBase();
         System.out.println(codeBase1);
         getAppletContext().showDocument(codeBase1);
      }
      catch (Exception ex)
      {
         String msg = new String("no refresh");
         System.out.println(msg);
         ex.printStackTrace();
      }
   }

   /**
    *
    * Action listener for buttons
    */

   public void actionPerformed(ActionEvent e)
   {
      this.Btn_actionPerformed(e);
   }

   void Btn_actionPerformed(ActionEvent e)
   {
      if(e.getSource().equals(mBack))
      {
         mBack_actionPerformed(e);
      }
   }

}

/**
 * Class to represent a row of the key details
 */
class SublicenseRow extends JPanel
{
   ResourceBundle resourceBundle;
   boolean isResourceBundleFound = false;
   JLabel lblSLCellAddress = new JLabel();
   JLabel lblSLInUse = new JLabel();
   JLabel lblSLLimit = new JLabel();
   GridLayout layout = new GridLayout();
   Color lblColor;
   Color borderColor;

   public SublicenseRow()
   {
      try
      {
         jbInit();
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
   }

   private void jbInit() throws Exception
   {
      try
      {
         if (System.getProperty("os.name").indexOf("Mac") != -1)
         {
            lblColor = new Color(0, 0, 90);
            borderColor = new Color(0, 0, 90);
         }
         else if (( System.getProperty("os.name").indexOf("Vista") != -1) || (System.getProperty("os.name").indexOf("Windows 7") != -1))
         {
            lblColor = new Color(0, 0, 90);
            borderColor = new Color(0, 0, 90);
         }
         else
         {
            lblColor = SystemColor.activeCaption; ;
            borderColor = Color.lightGray;
         }

         resourceBundle = ResourceBundle.getBundle("AppletResources");
         String testString = resourceBundle.getString("key");
         isResourceBundleFound = true;
      }
      catch (MissingResourceException e)
      {
         isResourceBundleFound = false;
      }
      catch (NullPointerException en)
      {
         isResourceBundleFound = false;
      }

      if (isResourceBundleFound == true)
      {
         lblSLCellAddress.setText(resourceBundle.getString("lblSLCellAddress"));
         lblSLInUse.setText(resourceBundle.getString("lblSLInUse"));
         lblSLLimit.setText(resourceBundle.getString("lblSLLimit"));
      }
      else
      {
         lblSLCellAddress.setText("Cell Address");
         lblSLInUse.setText("Number in Use");
         lblSLLimit.setText("Limit");
      }

      this.setLayout(layout);
      this.setBackground(Color.white);

      this.add(lblSLCellAddress,
            new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
      lblSLCellAddress.setHorizontalAlignment(SwingConstants.CENTER);

      this.add(lblSLInUse,
            new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
      lblSLInUse.setHorizontalAlignment(SwingConstants.CENTER);

      this.add(lblSLLimit,
            new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
      lblSLLimit.setHorizontalAlignment(SwingConstants.CENTER);

      lblSLCellAddress.setBorder(BorderFactory.createLineBorder(borderColor));
      lblSLCellAddress.setFont(new java.awt.Font("Serif", 1, 16));
      lblSLCellAddress.setForeground(lblColor);

      lblSLInUse.setBorder(BorderFactory.createLineBorder(borderColor));
      lblSLInUse.setFont(new java.awt.Font("Serif", 1, 16));
      lblSLInUse.setForeground(lblColor);

      lblSLLimit.setBorder(BorderFactory.createLineBorder(borderColor));
      lblSLLimit.setFont(new java.awt.Font("Serif", 1, 16));
      lblSLLimit.setForeground(lblColor);
   }
}
