/***************************************************************************
* LicenseInfoApplet.java
*
* (C) Copyright 2009 SafeNet, Inc. All rights reserved.
*
*
* Purpose     : To display the license details for a attached key using licenseinfo.xml.
*
* Refer to the ReadMe.pdf for customize details of Sentinel License Monitor.
*
****************************************************************************/

//imports
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import javax.swing.*;
import java.util.*;
import java.io.*;
import java.net.*;

/**
*The Applet to display the license information
*/
public class LicenseInfoApplet  extends Applet implements ActionListener{
//file to request from server for license details
  static public final String LICENSE_INFO_XML_FILE = "licenseinfo.xml";

  ResourceBundle              resourceBundle;
  //boolean variable for check the resource bundle
  boolean   isResourceBundleFound = false;

  JPanel mCenterPanel = new JPanel();
  JPanel mSouthPanel = new JPanel();
  JPanel mNorthPanel = new JPanel();



  JLabel LicLine1Heading = new JLabel();
  JLabel LicAddStaticLabel = new JLabel();
  Label mLicTopHeadingLabel   = new Label();
  JLabel LiclblError = new JLabel();
  JTextArea mLicFootNoteLabel = new JTextArea();
  Label mCopyrightLabel       = new Label();

  LicenseRow headingRow       = new LicenseRow();

  String tmpString            = new String();
  String xmlBuffer            = new String("");
  Vector vLicenseRow          = new Vector(2,1);
  Vector tmpVector            = new Vector(2,1);

  LicenseRow kKeysDetails;
  JButton mBack = new JButton();
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  GridBagLayout gridBagLayout2 = new GridBagLayout();
  GridBagLayout gridBagLayout3 = new GridBagLayout();
  GridBagLayout gridBagLayout4 = new GridBagLayout();
  Color lblColor, borderColor;

  //for refresh
  static int count = 0;
  
  //Construct the applet
  public LicenseInfoApplet() {
  }
  //Initialize the applet
  public void init() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  /**
  * Method to pad the serial number.
  */
    static public String PadSerialNumber(int input) {

      int width = 8; //pad for 8 digit wide
      //convert the serial number into the hex to display
      String output = Integer.toHexString(input);
      //convert to uppercase
      output = output.toUpperCase();

      for (int i = width - output.length(); i > 0; i--) {
        output = "0" + output;
      }
      //prefix it with the 0x
      output = "0x" + output;
      return output;
    }

  /**
  *Function to fill the data into the rows
  */
  private void fillRow(int iTotalKeysDetails)
  {
    XMLParser xParser = new XMLParser();
    try{
      LicenseRow tmpLicenseRow = new LicenseRow();
      tmpVector = xParser.getXMLTagValue(xmlBuffer, "ClientIPAddress");
      for (int k = 0; k < iTotalKeysDetails; k++) {
        tmpLicenseRow = (LicenseRow) vLicenseRow.get(k);
        String s = tmpVector.elementAt(k).toString();
        tmpLicenseRow.lblClientIP.setText(s);
      }

      tmpVector = xParser.getXMLTagValue(xmlBuffer, "ClientUserName");
      if (!tmpVector.isEmpty()) {
        for (int k = 0; k < iTotalKeysDetails; k++) {
          tmpLicenseRow = (LicenseRow) vLicenseRow.get(k);
          tmpLicenseRow.lblClientUserName.setText(tmpVector.elementAt(k).toString());
        }
      }

      tmpVector = xParser.getXMLTagValue(xmlBuffer, "ClientLogTime");
      for (int k = 0; k < iTotalKeysDetails; k++) {
        tmpLicenseRow = (LicenseRow) vLicenseRow.get(k);
        tmpLicenseRow.lblClientLogTime.setText(tmpVector.elementAt(k).toString());
      }

      tmpVector = xParser.getXMLTagValue(xmlBuffer, "ClientProcessID");
      for (int k = 0; k < iTotalKeysDetails; k++) {
        tmpLicenseRow = (LicenseRow) vLicenseRow.get(k);
        tmpLicenseRow.lblClientPID.setText(tmpVector.elementAt(k).toString());
      }
      //Add the keys row panel in the mCenterPanel
      for (int k = 0, j = 1; k < iTotalKeysDetails; k++, j++) {
        mCenterPanel.add( ( (LicenseRow) vLicenseRow.get(k)),
                         new GridBagConstraints(0, j, 1, 1, 1.0, 0.0
                                                , GridBagConstraints.NORTH,
                                                GridBagConstraints.HORIZONTAL,
                                                new Insets(0, 0, 0, 0), 0, 0));
        if ( (k == (iTotalKeysDetails - 1)) && (iTotalKeysDetails < 10)) {
          mCenterPanel.add(new JPanel(),
                           new GridBagConstraints(0, j, 1, 1, 1.0, 1.0
                                                  , GridBagConstraints.NORTH,
                                                  GridBagConstraints.HORIZONTAL,
                                                  new Insets(0, 0, 0, 0), 0, 0));
        }
      }


    }catch(Exception ex){
    }
  }

/**
   * The Method to get the licenseinfo.xml file from the server
   * */

void getLicenseInfoXML_File_from_Server(){
 String inputLine = null;
 try{
     URL rURL = new URL(getCodeBase() + this.LICENSE_INFO_XML_FILE);

     BufferedReader in = new BufferedReader(
                             new InputStreamReader(
                             rURL.openStream(), "UTF-8"));

      //get the contents of xml file in the buffer
      while ((inputLine = in.readLine()) != null)
        xmlBuffer = xmlBuffer + inputLine;

      in.close();  //close the BufferReader

   }catch (Exception ex) {
   }
 }


  /**
  *Applet initialization method
  */
  private void jbInit() throws Exception {
    String mLicFootNoteLabelStr = new String("Cannot display login time and process ID for the clients using Sentinel driver-based access modes (like SP_DRIVER_MODE for UltraPro clients and RNBO_SPN_DRIVER for SuperPro clients; these modes do not require Sentinel Protection Server to access the keys).");
    String LicAddStaticLabelStr = new String("Serial Number: ");
    String LiclblErrorStr = new String("No License details available");
    String XMLFileErrorStr = new String("Error in downloading the license information file.");
    try{
      if ( System.getProperty("os.name").indexOf("Mac") != -1)
      {
        lblColor = new Color(0,0,90);
        borderColor = new Color(0,0,90);
      }
      else if (( System.getProperty("os.name").indexOf("Vista") != -1) || (System.getProperty("os.name").indexOf("Windows 7") != -1))
      {
        lblColor = new Color(0,0,90);
        borderColor = new Color(0,0,90);
      }
      else{
        lblColor = SystemColor.activeCaption;
        borderColor = Color.lightGray;
      }

      resourceBundle = ResourceBundle.getBundle("AppletResources");
      //make a check if the bunde is present
      String tt = resourceBundle.getString("mLicTopHeadingLabel");
      isResourceBundleFound = true;
    }catch (MissingResourceException e){
      isResourceBundleFound = false;
    }catch (NullPointerException en){
      isResourceBundleFound = false;
    }
    //check if the resource bundle is found
    if(isResourceBundleFound == true)
    {
      mLicTopHeadingLabel.setText(resourceBundle.getString("mLicTopHeadingLabel"));
      LicLine1Heading.setText(resourceBundle.getString("LicLine1Heading"));
      mCopyrightLabel.setText(resourceBundle.getString("mCopyrightLabel"));
      mBack.setText(resourceBundle.getString("mBack"));
      mLicFootNoteLabelStr  = resourceBundle.getString("mLicFootNoteLabel");
      LicAddStaticLabelStr = resourceBundle.getString("LicAddStaticLabel");
      LiclblErrorStr = resourceBundle.getString("LiclblError");
      XMLFileErrorStr = resourceBundle.getString("XMLLicFileError");
    }else{
      mLicTopHeadingLabel.setText("License Usage for the Key");
      LicLine1Heading.setText("Following are the usage details of each license available with key.");
      mCopyrightLabel.setText("Copyright (c)2009 SafeNet, Inc.");
      mBack.setText("Back");
    }

    this.setLayout(gridBagLayout2);
    mNorthPanel.setLayout(gridBagLayout4);
    mLicTopHeadingLabel.setBackground(lblColor);
    mLicTopHeadingLabel.setFont(new java.awt.Font("Serif", 1, 24));
    mLicTopHeadingLabel.setForeground(Color.white);

    LicAddStaticLabel.setBackground(Color.white);
    LicAddStaticLabel.setFont(new java.awt.Font("Serif", 1, 15));
    LicAddStaticLabel.setForeground(lblColor);

    mCenterPanel.setLayout(gridBagLayout3);
    LicLine1Heading.setBackground(Color.white);
    LicLine1Heading.setFont(new java.awt.Font("Serif", 1, 14));
    LicLine1Heading.setForeground(lblColor);


    //The * is the mark for footnote.
    String footNote = new String("* ");
    footNote = footNote + mLicFootNoteLabelStr;
    mLicFootNoteLabel.setText(footNote);
    mLicFootNoteLabel.setLineWrap(true);
    mLicFootNoteLabel.setWrapStyleWord(true);

    mLicFootNoteLabel.setBackground(Color.white);
    mLicFootNoteLabel.setFont(new java.awt.Font("Serif", 0, 14));
    mLicFootNoteLabel.setForeground(new Color(0, 0, 90));
    mLicFootNoteLabel.setEditable(false);
    mLicFootNoteLabel.setMinimumSize(new Dimension(30, 40));
    mLicFootNoteLabel.setMaximumSize(new Dimension(30, 40));
    mLicFootNoteLabel.setPreferredSize(new Dimension(30, 40));

    mCopyrightLabel.setBackground(Color.white);
    mCopyrightLabel.setFont(new java.awt.Font("Serif", 0, 14));
    mCopyrightLabel.setForeground(new Color(0, 0, 90));

    mBack.setMinimumSize(new Dimension(90, 25));
    mBack.setPreferredSize(new Dimension(90, 25));
    mBack.addActionListener(this);

    LiclblError.setBackground(Color.white);
    LiclblError.setFont(new java.awt.Font("Serif", 1, 14));
    LiclblError.setForeground(Color.red);
    LiclblError.setVisible(false);
    this.setBackground(Color.white);
    this.setForeground(Color.white);
    mCenterPanel.setBackground(Color.white);
    mCenterPanel.setForeground(Color.black);
    mSouthPanel.setBackground(Color.white);
    mSouthPanel.setLayout(gridBagLayout1);

    mNorthPanel.setBackground(Color.white);
    JScrollPane mScrollPane = new JScrollPane();
    mScrollPane.setMaximumSize(new Dimension(500, 501));
    mScrollPane.setMinimumSize(new Dimension(500, 501));
    mScrollPane.setPreferredSize(new Dimension(500, 501));

    mCenterPanel.add(headingRow,     new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0
   ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));



    this.add(mScrollPane,     new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(15, 5, 15, 5), 0, 0));
    mScrollPane.getViewport().add(mCenterPanel, null);
    mScrollPane.setBorder(BorderFactory.createEmptyBorder());
    this.add(mSouthPanel,   new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0
            ,GridBagConstraints.SOUTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
    this.add(mNorthPanel,     new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));

        mNorthPanel.add(mLicTopHeadingLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0
                ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
        mNorthPanel.add(LicAddStaticLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0
                ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
        mNorthPanel.add(LicLine1Heading, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0
                ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
        mNorthPanel.add(LiclblError, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0
                ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));

    mSouthPanel.add(mLicFootNoteLabel,    new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    mSouthPanel.add(mCopyrightLabel,    new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
    mSouthPanel.add(mBack,   new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));


    //Request for the licenseinfo.xml file to server
    try {
      getLicenseInfoXML_File_from_Server();
      count = 0;
      XMLParser xParser = new XMLParser();

      //get the serial number from the licenseinfo file to display.
      tmpVector = xParser.getXMLTagValue(xmlBuffer, "SerialNumber");
      String finalSerialNumberToDisplay;

      String strSerialNumber = tmpVector.elementAt(0).toString();

      //get the serial number in decimal
      int iSerialNumber = Integer.parseInt(strSerialNumber);
      //pad the serial number to displays
      strSerialNumber = PadSerialNumber(iSerialNumber);

      finalSerialNumberToDisplay = LicAddStaticLabelStr + strSerialNumber;
      LicAddStaticLabel.setText(finalSerialNumberToDisplay);

      //get the number of keys Info in file
      tmpVector = xParser.getXMLTagValue(xmlBuffer, "LicenseDetails");
      if(tmpVector.isEmpty()){
        //Give the message for no keys details found in the xml file.
        LiclblError.setText(LiclblErrorStr);
        LiclblError.setVisible(true);
        mCenterPanel.add(new JPanel(),     new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
          ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
        return;

      }
      //Get the total number of keys
      int iTotalKeysDetails = 0;

      iTotalKeysDetails = tmpVector.size();

      for (int k = 0; k < iTotalKeysDetails; k++) {
        kKeysDetails = new LicenseRow();
        vLicenseRow.add(kKeysDetails);
      }

      fillRow(iTotalKeysDetails);

    }
    catch (Exception ex) 
    {
       if (xmlBuffer.length() == 0)
       {
          if (count < 5)
          {
             Thread.sleep(500);
             count++;
             getAppletContext().showDocument(getDocumentBase());
             return;
          }
       }

      LiclblError.setText(XMLFileErrorStr);
      LiclblError.setVisible(true);
      mCenterPanel.add(new JPanel(),     new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
          ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));

    }
  }


  //Start the applet
  public void start() {
  }

void mBack_actionPerformed(ActionEvent e) {
  try {
    String inputLine;
    URL codeBase1;
    codeBase1 = getCodeBase();
    System.out.println(codeBase1);
    getAppletContext().showDocument(codeBase1);
  }
  catch (Exception ex) {
    String msg = new String("no refresh");
    System.out.println(msg);
    ex.printStackTrace();
  }
}

 /**
  *
  * Action listener for buttons
  */

 public void actionPerformed(ActionEvent e) {
   this.Btn_actionPerformed(e);
 }

 void Btn_actionPerformed(ActionEvent e) {
   if(e.getSource().equals(mBack))
    mBack_actionPerformed(e);
 }

}

/**
* Class to represent a row of the key details
*/
class LicenseRow extends JPanel {
  ResourceBundle            resourceBundle;
  boolean   isResourceBundleFound = false;

  JLabel lblClientIP        = new JLabel();
  JLabel lblClientUserName  = new JLabel();
  JLabel lblClientLogTime   = new JLabel();
  JLabel lblClientPID       = new JLabel();
  GridLayout gridLayout1    = new GridLayout();
  Color lblColor, borderColor;

  public LicenseRow() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  private void jbInit() throws Exception {
    try{
      if ( System.getProperty("os.name").indexOf("Mac") != -1)
      {
        lblColor = new Color(0,0,90);
        borderColor = new Color(0,0,90);
      }
      else if (( System.getProperty("os.name").indexOf("Vista") != -1) || (System.getProperty("os.name").indexOf("Windows 7") != -1))
      {
        lblColor = new Color(0,0,90);
        borderColor = new Color(0,0,90);
      }
      else{
        lblColor = SystemColor.activeCaption;;
        borderColor = Color.lightGray;
      }

      resourceBundle = ResourceBundle.getBundle("AppletResources");
      this.setLayout(gridLayout1);
      this.setBackground(Color.white);
      //check if the resource bundle is present
      String testString = resourceBundle.getString("key");
      isResourceBundleFound = true;
    }catch (MissingResourceException e){
      isResourceBundleFound = false;
    }catch (NullPointerException en){
      isResourceBundleFound = false;
    }

    if(isResourceBundleFound == true)
    {
      lblClientIP.setText(resourceBundle.getString("lblClientIP"));
      lblClientUserName.setText(resourceBundle.getString("lblClientUserName"));
      lblClientLogTime.setText(resourceBundle.getString("lblClientLogTime"));
      lblClientPID.setText(resourceBundle.getString("lblClientPID"));
    }else{
      lblClientIP.setText("Client/Access Mode");
      lblClientUserName.setText("User Name");
      lblClientLogTime.setText("Client Login Time");
      lblClientPID.setText("Client Process ID");
    }

    this.add(lblClientIP,     new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0
  ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));


    lblClientIP.setHorizontalAlignment(SwingConstants.CENTER);
     this.add(lblClientUserName,     new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0
  ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));

    lblClientUserName.setHorizontalAlignment(SwingConstants.CENTER);

    this.add(lblClientLogTime,     new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0
  ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));

    lblClientLogTime.setHorizontalAlignment(SwingConstants.CENTER);

    this.add(lblClientPID,     new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0
   ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));

    lblClientPID.setHorizontalAlignment(SwingConstants.CENTER);

    lblClientIP.setBorder(BorderFactory.createLineBorder(borderColor));
    lblClientIP.setFont(new java.awt.Font("Serif", 1, 16));
    lblClientIP.setForeground(lblColor);
    lblClientUserName.setBorder(BorderFactory.createLineBorder(borderColor));
    lblClientUserName.setFont(new java.awt.Font("Serif", 1, 16));
    lblClientUserName.setForeground(lblColor);
    lblClientLogTime.setBorder(BorderFactory.createLineBorder(borderColor));
    lblClientLogTime.setFont(new java.awt.Font("Serif", 1, 16));
    lblClientLogTime.setForeground(lblColor);
    lblClientPID.setBorder(BorderFactory.createLineBorder(borderColor));
    lblClientPID.setFont(new java.awt.Font("Serif", 1, 16));
    lblClientPID.setForeground(lblColor);
  }
}
