/***************************************************************************
* KeyInfoApplet.java
*
* (C) Copyright 2009 SafeNet, Inc. All rights reserved.
*
*
* Purpose     : To display the keys details attached on the server using keyinfo.xml.
*
* Refer to the ReadMe.pdf for customize details of Sentinel License Monitor.
*
****************************************************************************/

//imports
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import javax.swing.*;
import java.util.*;
import java.io.*;
import java.net.*;
import javax.swing.border.*;


/**
*The Main Applet display the key information
*/
public class KeyInfoApplet extends Applet implements ActionListener{
//file to request from server for keys details
  static public final String KEYS_INFO_XML_FILE = "keyinfo.xml";

  ResourceBundle              resourceBundle;
  //boolean variable for check the resource bundle
  boolean   isResourceBundleFound = false;
  Panel mCenterPanel          = new Panel();
  Panel mSouthPanel           = new Panel();
  Panel mNorthPanel           = new Panel();
  GridLayout gridLayout1      = new GridLayout();
  GridLayout gridLayout3      = new GridLayout();

  BorderLayout borderLayout1  = new BorderLayout();

  Label mTopHeadingLabel      = new Label();
  Label SysAddStaticLabel     = new Label();
  Label mSSPVersionLabel      = new Label();
  Label KeyLine1Heading       = new Label();
  Label KeyLine2Heading       = new Label();
  Label mKeyFootNoteLabel     = new Label();
  Label mCopyrightLabel       = new Label();
  Label KeylblError           = new Label();

  KeysRow headingRow          = new KeysRow();

  String tmpString            = new String();
  String xmlBuffer            = new String("");
  Vector vKeysRow             = new Vector(2,1);
  Vector tmpVector            = new Vector(2,1);

  URL codeBase;
  KeysRow kKeysDetails;
  JButton mRefresh = new JButton();
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  Color lblColor, borderColor;

  //Construct the applet
  public KeyInfoApplet() {

  }
  //Initialize the applet
  public void init() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

/**
* Method to pad the serial number.
*/
  static public String PadSerialNumber(int input) {

    int width = 8; //pad for 8 digit wide
    //convert the serial number into the hex to display
    String output = Integer.toHexString(input);
    //convert to uppercase
    output = output.toUpperCase();

    for (int i = width - output.length(); i > 0; i--) {
      output = "0" + output;
    }
    //prefix it with the 0x
    output = "0x" + output;
    return output;
  }

  /**
  *Function to fill the data into the rows
  */
  private void fillRow(int iTotalKeysDetails)
  {
    XMLParser xParser = new XMLParser();
    String  strSerialNumber;
    try{
      KeysRow tmpKeysRow = new KeysRow();
      //fill the Keys#

      for (int k = 0; k < iTotalKeysDetails; k++) {
        tmpKeysRow = (KeysRow) vKeysRow.get(k);
        tmpString = String.valueOf(k + 1);
        tmpKeysRow.lblKeysH.setText(tmpString);
        tmpKeysRow.lblKeysH.setForeground(Color.blue);

      }
      tmpVector = xParser.getXMLTagValue(xmlBuffer, "SerialNumber");
      for (int k = 0; k < iTotalKeysDetails; k++) {
        tmpKeysRow = (KeysRow) vKeysRow.get(k);
        strSerialNumber = tmpVector.elementAt(k).toString();
        //store the serial number in decimal
        tmpKeysRow.serialNumber = Integer.parseInt(strSerialNumber);
        //pad the serial number to display
        strSerialNumber = PadSerialNumber(tmpKeysRow.serialNumber);
        tmpKeysRow.lblSerialNumber.setText(strSerialNumber);
      }

      tmpVector = xParser.getXMLTagValue(xmlBuffer, "KeyType");
      for (int k = 0; k < iTotalKeysDetails; k++) {
        tmpKeysRow = (KeysRow) vKeysRow.get(k);
        /*
         The KeyType values are as follows:
           0 - for SuperPro keys
           1 - for UltraPro Keys
           2 - for UltraPro RTC Keys
         */
        if(Integer.parseInt(tmpVector.elementAt(k).toString()) == 1)
        {
          tmpKeysRow.lblKeyType.setText("UltraPro");
          tmpKeysRow.lblSublicense.setText("N/A");
        }
        else if(Integer.parseInt(tmpVector.elementAt(k).toString()) == 2)
        {
          tmpKeysRow.lblKeyType.setText("UltraPro XMT");
          tmpKeysRow.lblSublicense.setText("N/A");
        }
        else if(Integer.parseInt(tmpVector.elementAt(k).toString()) == 0)
        {
          tmpKeysRow.lblKeyType.setText("SuperPro");
          tmpKeysRow.lblSublicense.setText(">>");
        }
        else
        {
          tmpKeysRow.lblKeyType.setText("Unknown");
          tmpKeysRow.lblSublicense.setText("N/A");
        }
       }
       tmpVector = xParser.getXMLTagValue(xmlBuffer, "FormFactor");
       for (int k = 0; k < iTotalKeysDetails; k++)
       {
          tmpKeysRow = (KeysRow)vKeysRow.get(k);
          /*
         The KeyType values are as follows:
             0 - for parallel keys
             1 - for USB keys
             2 - for SuperPro software Keys
           */
          if (Integer.parseInt(tmpVector.elementAt(k).toString()) == 0)
          {
             tmpKeysRow.lblFormFactor.setText("PARALLEL");
          }
          else if (Integer.parseInt(tmpVector.elementAt(k).toString()) == 1)
          {
             tmpKeysRow.lblFormFactor.setText("USB");
          }
          else if (Integer.parseInt(tmpVector.elementAt(k).toString()) == 2)
          {
             tmpKeysRow.lblFormFactor.setText("SOFT");             
          }
          else
          {
             tmpKeysRow.lblFormFactor.setText("Unknown");
          }
       }
      tmpVector = xParser.getXMLTagValue(xmlBuffer, "HardLimit");
      for (int k = 0; k < iTotalKeysDetails; k++) {
        tmpKeysRow = (KeysRow) vKeysRow.get(k);
        tmpKeysRow.lblHardLimit.setText(tmpVector.elementAt(k).toString());
      }

      tmpVector = xParser.getXMLTagValue(xmlBuffer, "LicenseInUse");
      for (int k = 0; k < iTotalKeysDetails; k++) {
        tmpKeysRow = (KeysRow) vKeysRow.get(k);
        tmpKeysRow.lblLicInUse.setText(tmpVector.elementAt(k).toString());
      }
      tmpVector = xParser.getXMLTagValue(xmlBuffer, "HighestUse");
      for (int k = 0; k < iTotalKeysDetails; k++) {
        tmpKeysRow = (KeysRow) vKeysRow.get(k);
        tmpKeysRow.lblHighestUse.setText(tmpVector.elementAt(k).toString());
      }
      tmpVector = xParser.getXMLTagValue(xmlBuffer, "NumTimeOut");
      for (int k = 0; k < iTotalKeysDetails; k++) {
        tmpKeysRow = (KeysRow) vKeysRow.get(k);
        tmpKeysRow.lblNumTimeOut.setText(tmpVector.elementAt(k).toString());
      }

      tmpVector = xParser.getXMLTagValue(xmlBuffer, "PartNumber");
      if (!tmpVector.isEmpty()) {
        for (int k = 0; k < iTotalKeysDetails; k++) {
          tmpKeysRow = (KeysRow) vKeysRow.get(k);
          tmpKeysRow.lblPartNumber.setText(tmpVector.elementAt(k).toString());
        }
      }

      //Add the keys row panel in the mCenterPanel
      for (int k = 0; k < iTotalKeysDetails; k++) {
        mCenterPanel.add( ( (KeysRow) vKeysRow.get(k)), null);
      }
    }catch(Exception ex){

    }
  }

/**
   * The Method to get the keyinfo.xml file from the server
   * */

void getKeyInfoXML_File_from_Server(){
 String inputLine = null;
 try{
   URL rURL = new URL(getCodeBase() + this.KEYS_INFO_XML_FILE);

   BufferedReader in = new BufferedReader(
                           new InputStreamReader(
                           rURL.openStream()));

   //get the contents of xml file in the buffer
   while ((inputLine = in.readLine()) != null)
   xmlBuffer = xmlBuffer + inputLine;

   in.close();  //close the BufferReader
   }catch (Exception ex) {
   }
 }

  /**
  *Applet initialization method
  */
  private void jbInit() throws Exception
  {
     //initialize the strings
     String SysAddStaticLabelStr = new String("System Address: ");
     String mSSPVersionLabelStr = new String("Sentinel Protection Server Version ");
     String mKeyFooNoteLabel1Str = new String("Not available. The model number cannot be obtained for certain keys. Please contact your developer/vendor for more information.");
     String KeylblErrorStr = new String("No Keys details available");
     String XMLFileErrorStr = new String("Error in downloading the key information file.");
     
     codeBase = getCodeBase();
     
     if (System.getProperty("os.name").indexOf("Mac") != -1)
     {
        lblColor = new Color(0,0,90);
        borderColor = new Color(0,0,90);
     }
     else if ((System.getProperty("os.name").indexOf("Vista") != -1) || (System.getProperty("os.name").indexOf("Windows 7") != -1))
     {
        lblColor = new Color(0,0,90);
        borderColor = new Color(0,0,90);
     }
     else
     {
        lblColor = SystemColor.activeCaption;
        borderColor = Color.lightGray;
     }
     
     try
     {
        resourceBundle = ResourceBundle.getBundle("AppletResources");
        String testString = resourceBundle.getString("key");
        isResourceBundleFound = true;
     }
     catch (MissingResourceException e)
     {
        isResourceBundleFound = false;
     }
     catch (NullPointerException en)
     {
        isResourceBundleFound = false;
     }

     //check if the resource bundle is found
     if (isResourceBundleFound == true)
     {
        mTopHeadingLabel.setText(resourceBundle.getString("mTopHeadingLabel"));
        SysAddStaticLabelStr = resourceBundle.getString("SysAddStaticLabel");
        mSSPVersionLabelStr = resourceBundle.getString("mSSPVersionLabel");
        KeyLine1Heading.setText(resourceBundle.getString("KeyLine1Heading"));
        KeyLine2Heading.setText(resourceBundle.getString("KeyLine2Heading"));
        mCopyrightLabel.setText(resourceBundle.getString("mCopyrightLabel"));
        mRefresh.setText(resourceBundle.getString("mRefresh"));
        mKeyFooNoteLabel1Str = resourceBundle.getString("mKeyFootNoteLabel");
        KeylblErrorStr = resourceBundle.getString("KeylblError");
        XMLFileErrorStr = resourceBundle.getString("XMLKeyFileError");
     }
     else
     {
        mTopHeadingLabel.setText("Sentinel License Monitor");
        KeyLine1Heading.setText("This web page shows you details of the keys attached/installed on the system.");
        KeyLine2Heading.setText("Please click on a key number to view the details about the clients who are using the licenses available with this key.");
        mCopyrightLabel.setText("Copyright (c)2009 SafeNet, Inc.");
        mRefresh.setText("Refresh");
     }
     
     //set system address
     SysAddStaticLabelStr = SysAddStaticLabelStr + "<" + codeBase+ ">";
     SysAddStaticLabel.setText(SysAddStaticLabelStr);
     
     this.setLayout(borderLayout1);
     
     mTopHeadingLabel.setBackground(lblColor);
     mTopHeadingLabel.setFont(new java.awt.Font("Serif", 1, 24));
     mTopHeadingLabel.setForeground(Color.white);
     SysAddStaticLabel.setFont(new java.awt.Font("Serif",1, 14));
     SysAddStaticLabel.setForeground(lblColor);
     mSSPVersionLabel.setFont(new java.awt.Font("Serif", 1, 14));
     mSSPVersionLabel.setForeground(lblColor);
     gridLayout1.setColumns(0);
     gridLayout1.setRows(3);
     mNorthPanel.setLayout(gridLayout1);
     mNorthPanel.setBackground(Color.white);
     mNorthPanel.add(mTopHeadingLabel, null);
     mNorthPanel.add(SysAddStaticLabel, null);
     mNorthPanel.add(mSSPVersionLabel, null);
     this.add(mNorthPanel, BorderLayout.NORTH);

     KeyLine1Heading.setFont(new java.awt.Font("Serif", 1, 14));
     KeyLine1Heading.setForeground(lblColor);
     KeyLine2Heading.setFont(new java.awt.Font("Serif", 1, 14));
     KeyLine2Heading.setForeground(lblColor);
     KeylblError.setFont(new java.awt.Font("Serif", 1, 14));
     KeylblError.setForeground(new Color(203, 0, 0));
     KeylblError.setVisible(false);
     headingRow.setBackground(Color.white);
     headingRow.setFont(new java.awt.Font("Serif", 0, 14));
     headingRow.setForeground(new Color(0, 0, 90));
     gridLayout3.setRows(13);
     mCenterPanel.setLayout(gridLayout3);
     mCenterPanel.setBackground(Color.white);
     this.setBackground(Color.white);
     mCenterPanel.add(KeyLine1Heading, null);
     mCenterPanel.add(KeyLine2Heading, null);
     mCenterPanel.add(KeylblError, null);
     mCenterPanel.add(headingRow, null);
     try
     {
        //Request for the keyinfo.xml file to server
        getKeyInfoXML_File_from_Server();

        XMLParser xParser = new XMLParser();

        //set the server version
        Vector serverDetails = new Vector(2, 1);
        serverDetails = xParser.getXMLTagValue(xmlBuffer, "ServerVersion");
        if(!serverDetails.isEmpty())
        {
           mSSPVersionLabelStr = mSSPVersionLabelStr + serverDetails.elementAt(0);
        }
        else
        {
           mSSPVersionLabelStr = mSSPVersionLabelStr + "7.6.0"; //hard code server version
        }
        serverDetails = null;
        mSSPVersionLabel.setText(mSSPVersionLabelStr);

        //get the number of key Info in file
        tmpVector = xParser.getXMLTagValue(xmlBuffer, "KeyDetails");
        if(tmpVector.isEmpty())
        {
           KeylblError.setText(KeylblErrorStr);
           KeylblError.setVisible(true);
        }
        else
        {
           int iTotalKeysDetails = 0;
           iTotalKeysDetails = tmpVector.size();
           
           //Manipulation with the rows
           if (iTotalKeysDetails > 9)
           {
              gridLayout3.setRows(iTotalKeysDetails + 4);
           }
           
           for (int k = 0; k < iTotalKeysDetails; k++)
           {
              kKeysDetails = new KeysRow(this, codeBase);
              vKeysRow.add(kKeysDetails);
           }
           fillRow(iTotalKeysDetails);
        }
     }
     catch (Exception ex)
     {
        KeylblError.setText(XMLFileErrorStr);
        KeylblError.setVisible(true);
     }

     this.add(mCenterPanel, BorderLayout.CENTER);

     String footNote = new String("* ");
     footNote = footNote + mKeyFooNoteLabel1Str;
     mKeyFootNoteLabel.setText(footNote);
     mKeyFootNoteLabel.setBackground(Color.white);
     mKeyFootNoteLabel.setFont(new java.awt.Font("Serif", 0, 14));
     mKeyFootNoteLabel.setForeground(new Color(0, 0, 90));
     mCopyrightLabel.setBackground(Color.white);
     mCopyrightLabel.setFont(new java.awt.Font("Serif", 0, 14));
     mCopyrightLabel.setForeground(new Color(0, 0, 90));
     mRefresh.setMinimumSize(new Dimension(90, 25));
     mRefresh.setPreferredSize(new Dimension(90, 25));
     mRefresh.addActionListener(this);
     mSouthPanel.setLayout(gridBagLayout1);
     mSouthPanel.setBackground(Color.white);
     this.add(mSouthPanel,  BorderLayout.SOUTH);
     mSouthPanel.add(mKeyFootNoteLabel,     
       new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
     mSouthPanel.add(mCopyrightLabel,
       new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
    mSouthPanel.add(mRefresh,
       new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
   }

  //Start the applet
  public void start() {
   }

  void mRefresh_actionPerformed(ActionEvent e) {
    try {
      String inputLine;
      URL codeBase1;
      codeBase1 = getCodeBase();
      System.out.println(codeBase1);
      getAppletContext().showDocument(codeBase1);
    }
    catch (Exception ex) {
      String msg = new String("no refresh");
      System.out.println(msg);
      ex.printStackTrace();
    }

  }
  //Stop the applet
/*  public void stop() {
  }
  //Destroy the applet
  public void destroy() {
  }
*/
/**
 *
 * Action listener for buttons
 */

public void actionPerformed(ActionEvent e) {
  this.Btn_actionPerformed(e);
}

void Btn_actionPerformed(ActionEvent e) {
  if(e.getSource().equals(mRefresh))
   mRefresh_actionPerformed(e);
}

}

/**
* Class to represent a row of the key details
*/
class KeysRow extends Panel{
  ResourceBundle          resourceBundle;
  JLabel lblKeysH         = new JLabel();
  JLabel lblKeyType       = new JLabel();
  JLabel lblFormFactor    = new JLabel();
  JLabel lblSerialNumber  = new JLabel();
  JLabel lblPartNumber    = new JLabel();
  JLabel lblHardLimit     = new JLabel();
  JLabel lblLicInUse      = new JLabel();
  JLabel lblHighestUse    = new JLabel();
  JLabel lblNumTimeOut    = new JLabel();
  JLabel lblSublicense    = new JLabel();
  int    serialNumber;  //To store the key serial number in decimal
  GridLayout gridLayout1  = new GridLayout();
  Border m_activeBorder   = new MatteBorder(1, 1, 1, 1, Color.yellow);

  URL codeBase;
  KeyInfoApplet parent;

  boolean   isResourceBundleFound = false;
  Color lblColor, borderColor;
  public KeysRow() {
    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  public KeysRow(KeyInfoApplet parent, URL uCodeBase) {
    try {
      codeBase = uCodeBase;
      this.parent = parent;
      jbInit();

    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    try{
      if ( System.getProperty("os.name").indexOf("Mac") != -1)
      {
        lblColor = new Color(0,0,90);
        borderColor = new Color(0,0,90);
      }
      else if (( System.getProperty("os.name").indexOf("Vista") != -1) || (System.getProperty("os.name").indexOf("Windows 7") != -1))
      {
        lblColor = new Color(0,0,90);
        borderColor = new Color(0,0,90);
      }      
      else{
        lblColor = SystemColor.activeCaption;
        borderColor = Color.lightGray;
      }


      resourceBundle = ResourceBundle.getBundle("AppletResources");
                                                //, Locale.getDefault());
      //check if the resource bundle is present
      String testString = resourceBundle.getString("key");

      isResourceBundleFound = true;
    }catch (MissingResourceException e){
      isResourceBundleFound = false;
    }catch (NullPointerException en){
      isResourceBundleFound = false;
    }

    if(isResourceBundleFound == true)
    {
      lblKeysH.setText(resourceBundle.getString("lblKeysH"));
      lblKeyType.setText(resourceBundle.getString("lblKeyType"));
      lblFormFactor.setText(resourceBundle.getString("lblFormFactor"));
      lblSerialNumber.setText(resourceBundle.getString("lblSerialNumber"));
      lblPartNumber.setText(resourceBundle.getString("lblPartNumber"));
      lblHardLimit.setText(resourceBundle.getString("lblHardLimit"));
      lblLicInUse.setText(resourceBundle.getString("lblLicInUse"));
      lblHighestUse.setText(resourceBundle.getString("lblHighestUse"));
      lblNumTimeOut.setText(resourceBundle.getString("lblNumTimeOut"));
      lblSublicense.setText(resourceBundle.getString("lblSublicense"));
    }else{
      lblKeysH.setText("Keys#");
      lblKeyType.setText("Key Type");
      lblFormFactor.setText("Form Factor");
      lblSerialNumber.setText("Serial Number");
      lblPartNumber.setText("Model Number");
      lblHardLimit.setText("Hard Limit");
      lblLicInUse.setText("Licenses-In-Use");
      lblHighestUse.setText("Highest Used");
      lblNumTimeOut.setText("Time-Outs ");
      lblSublicense.setText("Sublicense");
    }
    lblKeysH.addMouseListener(new LabelAdapter(this));
    lblSublicense.addMouseListener(new LabelAdapter(this));

    this.setLayout(gridLayout1);
    this.add(lblKeysH, null);
    lblKeysH.setHorizontalAlignment(SwingConstants.CENTER);
    this.add(lblKeyType, null);
    lblKeyType.setHorizontalAlignment(SwingConstants.CENTER);
    this.add(lblFormFactor, null);
    lblFormFactor.setHorizontalAlignment(SwingConstants.CENTER);
    this.add(lblSerialNumber, null);
    lblSerialNumber.setHorizontalAlignment(SwingConstants.CENTER);
    this.add(lblPartNumber, null);
    lblPartNumber.setHorizontalAlignment(SwingConstants.CENTER);
    this.add(lblHardLimit, null);
    lblHardLimit.setHorizontalAlignment(SwingConstants.CENTER);
    this.add(lblLicInUse, null);
    lblLicInUse.setHorizontalAlignment(SwingConstants.CENTER);
    this.add(lblHighestUse, null);
    lblHighestUse.setHorizontalAlignment(SwingConstants.CENTER);
    this.add(lblNumTimeOut, null);
    lblNumTimeOut.setHorizontalAlignment(SwingConstants.CENTER);
    this.add(lblSublicense, null);
    lblSublicense.setHorizontalAlignment(SwingConstants.CENTER);

    lblKeysH.setBorder(BorderFactory.createLineBorder(lblColor));
    lblKeysH.setFont(new java.awt.Font("Serif", 1, 16));
    lblKeysH.setForeground(lblColor);
    lblKeyType.setBorder(BorderFactory.createLineBorder(lblColor));
    lblKeyType.setFont(new java.awt.Font("Serif", 1, 16));
    lblKeyType.setForeground(lblColor);
    lblFormFactor.setBorder(BorderFactory.createLineBorder(lblColor));
    lblFormFactor.setFont(new java.awt.Font("Serif", 1, 16));
    lblFormFactor.setForeground(lblColor);
    lblSerialNumber.setBorder(BorderFactory.createLineBorder(lblColor));
    lblSerialNumber.setFont(new java.awt.Font("Serif", 1, 16));
    lblSerialNumber.setForeground(lblColor);
    lblPartNumber.setBorder(BorderFactory.createLineBorder(lblColor));
    lblPartNumber.setFont(new java.awt.Font("Serif", 1, 16));
    lblPartNumber.setForeground(lblColor);
    lblHardLimit.setBorder(BorderFactory.createLineBorder(lblColor));
    lblHardLimit.setFont(new java.awt.Font("Serif", 1, 16));
    lblHardLimit.setForeground(lblColor);
    lblLicInUse.setBorder(BorderFactory.createLineBorder(lblColor));
    lblLicInUse.setFont(new java.awt.Font("Serif", 1, 16));
    lblLicInUse.setForeground(lblColor);
    lblHighestUse.setBorder(BorderFactory.createLineBorder(lblColor));
    lblHighestUse.setFont(new java.awt.Font("Serif", 1, 16));
    lblHighestUse.setForeground(lblColor);
    lblNumTimeOut.setBorder(BorderFactory.createLineBorder(lblColor));
    lblNumTimeOut.setFont(new java.awt.Font("Serif", 1, 16));
    lblNumTimeOut.setForeground(lblColor);
    lblSublicense.setBorder(BorderFactory.createLineBorder(lblColor));
    lblSublicense.setFont(new java.awt.Font("Serif", 1, 16));
    lblSublicense.setForeground(lblColor);
  }

  /**
   * Make the cursor icon to HAND shape
   */
   void chageCursorHand(MouseEvent e)
   {
      if (
         (((JLabel)e.getComponent()).getText().compareTo("Keys#") != 0) &&
         (((JLabel)e.getComponent()).getText().compareTo("Sublicense") != 0) &&
         (((JLabel)e.getComponent()).getText().compareTo("N/A") != 0)
         )
      {
         setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
         ((JLabel)e.getComponent()).setBorder(m_activeBorder);
         ((JLabel)e.getComponent()).repaint();
      }
   }

  /**
  * change mouse cursor icon to default
  */
   void chageCursorDefault(MouseEvent e)
   {
      if (
         (((JLabel)e.getComponent()).getText().compareTo("Keys#") != 0) &&
         (((JLabel)e.getComponent()).getText().compareTo("Sublicense") != 0) &&
         (((JLabel)e.getComponent()).getText().compareTo("N/A") != 0)
         )
      {
         setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
         ((JLabel)e.getComponent()).setBorder(BorderFactory.createLineBorder(lblColor));
         ((JLabel)e.getComponent()).repaint();
      }
   }

/**
* The Method to get the licenseinfo.html file from the server to get the license details.
* */

void displayLicenseDetails()
{
    String strSerialNumber;

  try {
    strSerialNumber = Integer.toString(this.serialNumber);

    URL url = new URL(codeBase + "licenseinfo.html" + "?" +
                      this.lblKeysH.getText() + "?" + strSerialNumber);

    System.out.println(url);
    parent.getAppletContext().showDocument(url);
   }
   catch (Exception ex) {
     System.out.println("Error in downloading the second Applet.");
     ex.printStackTrace();
  }

}

void displaySublicenseDetails()
{
   String strSerialNumber;
   String strKeyType;
   int iKeyType = 0;
   try
   {
      strSerialNumber = Integer.toString(this.serialNumber);
      strKeyType = this.lblFormFactor.getText();
      if (strKeyType.compareTo("UNKNOWN") == 0)
      {
    	  return;
      }
      URL url = new URL(codeBase + "sublicenseinfo.html?" + this.lblKeysH.getText() + "?" + strSerialNumber);
      System.out.println(url);
      parent.getAppletContext().showDocument(url);
   }
   catch (Exception ex)
   {
      System.out.println("Error in downloading applet.");
      ex.printStackTrace();
   }
}

  /**
  * Send a request to the server for the license details for a selected key
  */
   void lbl_mousePressed(MouseEvent e)
   {
      if (((JLabel)e.getComponent()).getText().compareTo("N/A") == 0)
      {
         return;
      }

      if (((JLabel)e.getComponent()).getText().compareTo(">>") == 0)
      {
         displaySublicenseDetails();
         return;
      }

      if (((JLabel)e.getComponent()).getText().compareTo("Keys#") != 0)
      {
         displayLicenseDetails();
      }
   }
}

/**
* Class to process the mouse events generated
*/
class LabelAdapter extends java.awt.event.MouseAdapter
{
   KeysRow adaptee;

   LabelAdapter(KeysRow adaptee)
   {
      this.adaptee = adaptee;
   }
   public void mouseEntered(MouseEvent e)
   {
      adaptee.chageCursorHand(e);
   }
   public void mouseExited(MouseEvent e)
   {
      adaptee.chageCursorDefault(e);
   }
   public void mousePressed(MouseEvent e)
   {
      adaptee.lbl_mousePressed(e);
   }
}
