/***************************************************************************
* CPasswordDlg.java
*
* (C) Copyright 2009 SafeNet, Inc. All rights reserved.
*
*
* Purpose     : The Password dialog.
*
* Refer to the ReadMe.pdf for customize details of Sentinel License Monitor.
*
****************************************************************************/

import javax.swing.*;
import java.awt.*;
import javax.swing.border.*;
import java.awt.event.*;

public class CPasswordDlg extends JDialog implements ActionListener{

  private String mPassword;

  JPanel mPanelMain = new JPanel();
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  JLabel mInfo_Password = new JLabel();
  JLabel jLabel1 = new JLabel();
  JPasswordField mPasswordField = new JPasswordField(20);
  JButton mCancel = new JButton();
  JButton mOk = new JButton();
  Border border1;
  public int state = 0;
  private String mDesignUnLockPassword;

  public CPasswordDlg(){

  //  super(CProjectListData.InstanceOf().MainFrameObject);
    try {
      this.setResizable(false);
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

/*
   *return the password
   */
  public String getPassword(){
    return mPassword;
  }

  private void jbInit() throws Exception {
    this.setSize(400,170);

    Dimension us = this.getSize();
    Dimension  them = Toolkit.getDefaultToolkit().getScreenSize();

    int newX = (them.width - us.width) / 2;
    int newY = (them.height- us.height)/ 2;
    this.setLocation(newX, newY);
    this.setModal(true);


    this.setTitle("Password");

    mCancel.setFont(new java.awt.Font("Dialog", 0, 12));
    mCancel.setMinimumSize(new Dimension(90, 25));
    mCancel.setPreferredSize(new Dimension(90, 25));
    mCancel.setText("Cancel");
    mOk.setFont(new java.awt.Font("Dialog", 0, 12));
    mOk.setMinimumSize(new Dimension(90, 25));
    mOk.setPreferredSize(new Dimension(90, 25));

    getRootPane().setDefaultButton( mOk );

    mPanelMain.setLayout(gridBagLayout1);
    mInfo_Password.setFont(new java.awt.Font("Dialog", 0, 12));
    mInfo_Password.setText("<html>Enter the authentication password to complete the license cancel request.</html>");
    jLabel1.setFont(new java.awt.Font("Dialog", 0, 12));
    jLabel1.setText("Password:");
    mPasswordField.setFont(new java.awt.Font("Dialog", 0, 12));
    mOk.setText("OK");

    mOk.addActionListener(this);
    mCancel.addActionListener(this);


    this.getContentPane().add(mPanelMain,  BorderLayout.CENTER);
    mPanelMain.add(mCancel,    new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(15, 0, 10, 10), 0, 0));
    mPanelMain.add(mOk,    new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(15, 0, 10, 5), 0, 0));
    mPanelMain.add(mInfo_Password,                                  new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0
            ,GridBagConstraints.NORTHWEST, GridBagConstraints.HORIZONTAL, new Insets(10, 10, 0, 10), 0, 0));
    mPanelMain.add(mPasswordField,              new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0
            ,GridBagConstraints.NORTHWEST, GridBagConstraints.HORIZONTAL, new Insets(10, 5, 0, 10), 0, 0));
    mPanelMain.add(jLabel1,         new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.NORTHWEST, GridBagConstraints.NONE, new Insets(10, 10, 0, 0), 0, 0));
  }

  void mOk_actionPerformed(ActionEvent e) {

    char cTemp[];
    String sInPasword;
    cTemp = mPasswordField.getPassword();
    sInPasword = new String(cTemp);
/*
    if((sInPasword.length() <= 8)){
      JOptionPane.showMessageDialog (this, "The password is incorrect. Please retype your password"
                                     , "Sentinel Protection Server", JOptionPane.ERROR_MESSAGE);
      mPasswordField.requestFocus(true);
      mPasswordField.setCaretPosition(0);

    }else{
*/
      mPassword = sInPasword;
      state = 1; //for ok
      this.setVisible(false);
//    }

  }

  public void actionPerformed(ActionEvent e) {
    this.Btn_actionPerformed(e);
  }

  void mCancel_actionPerformed(ActionEvent e) {
    state = 2; //for Cancel
    mPasswordField.setText("");
    this.setVisible(false);

  }

  void Btn_actionPerformed(ActionEvent e) {
    if(e.getSource().equals(mOk))
     mOk_actionPerformed(e);
    if(e.getSource().equals(mCancel))
      mCancel_actionPerformed(e);
  }

}
