/***************************************************************************
* CMessage.java
*
* (C) Copyright 2009 SafeNet, Inc. All rights reserved.
*
*
* Description : This generate the message to send the server.
*
* Purpose     : Used to construct/split the message.
*
****************************************************************************/

import java.util.*;
import java.io.*;
import java.net.*;
import javax.swing.JOptionPane;
import java.lang.Integer;

class CMessage{
  private Socket sock;
  private int port;
  private DataInputStream reader;
//  private PrintWriter writer;
  private BufferedWriter writer;
  //The message(s) will have three levels - level1, level 2 and level3
  static public final String LEVEL1_SEP = "###";
  static public final String LEVEL2_SEP = "!!!";
  static public final String LEVEL3_SEP = "$$$";

//Message ID
  static public final String LIC_HELLO = "40";
  static public final String LIC_DELETE = "41";
  static public final String LIC_DELETE_RESPONSE = "42";
//IDs of protocols supported
  static public final String  CHAP_PROTOCOL_ID  = "49699";

//IDs of algos supported
  static public final String MD5_ALGO_ID = "5";

  static public final String CLIENT_VER = "7.2.0";
  static public final String SERVER_ERROR = "error";
  static public final String SERVER_SUCCESS = "success";

  static public final int CLIENT_ERROR = 1;
  static public final int CLIENT_SUCCESS = 0;



// constructor
  CMessage()
  {
  }

  public void open(URL url)
  {
    String openURL;

    //Extract the host address from the URL
    openURL = url.getHost();
    //Extract the port number from the URL
    port = url.getPort();
    //if no port is extracted from the URL then 80 is the default HTTPport
    if(port == -1)
      port = 80;

//    System.out.println("The Host = " + openURL + "port = " + port);

    try {
      sock = new Socket(openURL, port);
//      sock = new Socket("192.168.100.103", port);
      reader = new DataInputStream(sock.getInputStream());
//      writer = new PrintWriter(new OutputStreamWriter(sock.getOutputStream()));
      writer = new BufferedWriter(new OutputStreamWriter(sock.getOutputStream()));
      sock.setKeepAlive(true);
      sock.setSoTimeout(5000);
      System.out.println("The socket number is :=" + sock);
    }
    catch (IOException  e1) {
      System.out.println("open exception: " + e1.toString());
      System.out.println("open MSG: " + e1.getMessage());
      e1.printStackTrace();
    }

  }

  /**
   * close socket
   * @return
   */
  public void close()
  {
    try {
      reader.close();
      writer.close();
      sock.close();
    }
    catch (IOException  e1) {
      System.out.println("close error: " + e1.toString());
      System.out.println("close error MSG: " + e1.getMessage());
      e1.printStackTrace();
    }
  }

  /**
   *send the stream to the server
   * @return
   */

  public boolean send(String messageToSend)
  {
    try {
//      writer.println(messageToSend);
    writer.write(messageToSend);
      writer.flush();
//      writer;
    }
    catch (IOException  e1){
      System.out.println("send exception: " + e1.toString());
      System.out.println("send MSG: " + e1.getMessage());
      e1.printStackTrace();
      return false;
    }
    return true;
  }

  /**
   *Receive the stream fom the server
   * @return
   */
  public String recv()
  {
    byte [] readBytes = new byte[512];
    try {
      reader.readFully(readBytes);
    } catch (EOFException exEOF) {
//      exEOF.printStackTrace();
    } catch (IOException exIO) {
//      exIO.printStackTrace();
    }

    int lengthx = readBytes.length -1;

    while((readBytes[lengthx] != 35) &&
          (readBytes[lengthx-1] != 35) &&
          (readBytes[lengthx-2] != 35)
          ) {
      lengthx--;
      if (lengthx <= 2) break;
    }

    byte [] tempBytes = new byte[lengthx+1];
    for ( int j = 0; j <= lengthx; j++) {
      tempBytes[j] = readBytes[j];
    }
    return new String(tempBytes);
  }

  public boolean isSucess(String separator, String strMessage)
  {
    Vector v = new Vector(2,1);
    v = splitMessage(separator, strMessage);

    //check if the scond field of message contains the error string

    if(v.elementAt(1).toString().compareTo(SERVER_SUCCESS) == 0)
      return true;
    else
      return false;
  }


  public boolean isError(String separator, String strMessage)
  {
    Vector v = new Vector(2,1);
    v = splitMessage(separator, strMessage);

    //check if the scond field of message contains the error string

    System.out.println("is error :" + v.elementAt(1).toString());
    if(v.elementAt(1).toString().compareTo(SERVER_ERROR) == 0)
    {
      return true;
    }
    else{
      return false;
    }
  }


  /**
  * construct message
  */
  public String constructMessage(String separator, Vector vMessage)
  {
    String strMessage = "";

    for(int i = 0 ; i < vMessage.size(); i++)
    {
      strMessage = strMessage + separator + vMessage.elementAt(i);
    }

    //add the separator in last
    strMessage = strMessage + separator;
    return strMessage;
  }


/**
* split message
*/
  public Vector splitMessage(String separator, String strMessage)
  {
    if ( System.getProperty("os.name").indexOf("Mac") != -1){//ups
      Vector vMessage = new Vector(2,1);
      StringTokenizer strTok = new StringTokenizer(strMessage, separator);
      while (strTok.hasMoreTokens()) {
        vMessage.addElement(strTok.nextToken());
      }
      return vMessage;
    }
    else{
      Vector vMessage = new Vector(2,1);
      String msgString[];

      msgString = strMessage.split(separator);

      for(int index = 0; index < msgString.length ; index ++)
      {
        if(msgString[index].length() != 0)
          vMessage.addElement(msgString[index]);
      }
      return vMessage;
    }
  }
}
