/***************************************************************************
* CMd5Chap.java
*
* (C) Copyright 2009 SafeNet, Inc. All rights reserved.
*
*
* Description : This generate the chap packet and md5 digest of the message.
*
* Purpose     : Used to construct chap packet.
*
****************************************************************************/

import java.awt.*;
import java.util.*;
import java.security.*;

/*
       Chap Packet Format -
       ---------------------
       +-------------------------------------------------------------------------------+
       |Code  |Identifier  |	Length		    |Value Size	    |Value	        |
       |      |(Session	   |	(Packet Size)	|(Challenge	    |(PRNG	        |
       |      | handle)	   |                |  Size)        |  Challenge)	  |
       +-------------------------------------------------------------------------------+

       Code -
       --------
       +---------------------------+
       | S.No.	|   CHAP Codes	|
       +---------------------------+
       | 1 	|   Challenge	|
       | 2	|   Response	|
       | 3	|   Success	|
       | 4	|   Failure	|
       +---------------------------+
       This will take one octect.

       Identifier -
       -------------
       Session Id or Session Handle
       This will take 1 octect [256 maximum connections].

       Length -
       ----------
       Packet Size
       This will take 2 octects.

       Value Size -
       -------------
       Challenge size
       This will take one octect.

       Value -
       --------
       Pseudo Random Number Generator(PRNG) Challenge
       Variable num of octects [16 octects in case of MD5].
 */


public class CMd5Chap {

//member variables
//The PRNG challange value come from server
  String PRNGChallange;
//chap packet
  byte [] chapPacket = new byte[MD5CHAP_RESPONSE_PACKET_LENGTH];
//sessionID for the CHAP packet
  byte sessionID = 0;

//defined values
  static public byte MD5CHAP_CHALLENGE  = 1;
  static public byte MD5CHAP_RESPONSE   = 2;
  static public byte MD5CHAP_SUCCESS    = 3;
  static public byte MD5CHAP_FAILURE    = 4;


//Defines for Challenge and Response Packet Octects
  static public byte MD5CHAP_CODE_OCTECT_LENGTH	        = 1;
  static public byte MD5CHAP_SESSION_ID_OCTECT_LENGTH	= 1;
  static public byte MD5CHAP_PACKET_SIZE_OCTECT_LENGTH	= 2;
  static public byte MD5CHAP_VALUE_SIZE_OCTECT_LENGTH   =1;

  static public byte MD5CHAP_CHALLENGE_OCTECT_LENGTH = 8;
  static public byte MD5CHAP_RESPONSE_OCTECT_LENGTH  = 16;

  static public byte MD5CHAP_SUCCESS_FAILURE_OCTECT_LENGTH = 0;


//Challenge Packet Length is defined below
  static public byte MD5CHAP_CHALLENGE_PACKET_LENGTH = (byte )(MD5CHAP_CODE_OCTECT_LENGTH +
                                                        MD5CHAP_SESSION_ID_OCTECT_LENGTH +
                                                        MD5CHAP_PACKET_SIZE_OCTECT_LENGTH +
                                                        MD5CHAP_VALUE_SIZE_OCTECT_LENGTH +
                                                        MD5CHAP_CHALLENGE_OCTECT_LENGTH);

//Response Packet Length is defined below
  static public byte MD5CHAP_RESPONSE_PACKET_LENGTH =  (byte )(MD5CHAP_CODE_OCTECT_LENGTH +
                                                        MD5CHAP_SESSION_ID_OCTECT_LENGTH +
                                                        MD5CHAP_PACKET_SIZE_OCTECT_LENGTH +
                                                        MD5CHAP_VALUE_SIZE_OCTECT_LENGTH +
                                                        MD5CHAP_RESPONSE_OCTECT_LENGTH);

//Success Failure Packet Length is defined below
  static public byte MD5CHAP_SUCCESS_FAILURE_PACKET_LENGTH = (byte )(MD5CHAP_CODE_OCTECT_LENGTH +
                                                        MD5CHAP_SESSION_ID_OCTECT_LENGTH +
                                                        MD5CHAP_PACKET_SIZE_OCTECT_LENGTH +
                                                        MD5CHAP_VALUE_SIZE_OCTECT_LENGTH);

//Halper functions
  static public byte LO_BYTE(int word) {
    return (byte )(word % 255);
  }

  static public byte HI_BYTE(int word){
    return (byte )(word / 255);
  }

  static public int FORM_WORD_FROM_BYTES(byte highByte, byte lowByte){
    return ((highByte * 0xFF) + lowByte);
  }

  static byte[] encode(byte[] data) {
    int c;
    int len = data.length;
    StringBuffer ret = new StringBuffer( ( (len / 3) + 1) * 4);
    for (int i = 0; i < len; ++i) {
      c = (data[i] >> 2) & 0x3f;
      ret.append(cvt.charAt(c));
      c = (data[i] << 4) & 0x3f;
      if (++i < len) {
        c |= (data[i] >> 4) & 0x0f;
      }

      ret.append(cvt.charAt(c));
      if (i < len) {
        c = (data[i] << 2) & 0x3f;
        if (++i < len) {
          c |= (data[i] >> 6) & 0x03;
        }

        ret.append(cvt.charAt(c));
      }
      else {
        ++i;
        ret.append( (char) fillchar);
      }

      if (i < len) {
        c = data[i] & 0x3f;
        ret.append(cvt.charAt(c));
      }
      else {
        ret.append( (char) fillchar);
      }
    }

    return (getBinaryBytes(ret.toString()));
  }

  private static byte[] getBinaryBytes(String str) {
    byte[] b = new byte[str.length()];
    for (int i = 0; i < b.length; ++i) {
      b[i] = (byte) str.charAt(i);
    }

    return (b);
  }

  private static final int fillchar = '=';
  private static final String cvt = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
      + "abcdefghijklmnopqrstuvwxyz"
      + "0123456789+/";
//constructor
  CMd5Chap(){

  }

 //construct the chap packet
  public String formChapPacket(String password){

    byte[] chapPacketResponse = new byte[MD5CHAP_RESPONSE_PACKET_LENGTH];

    byte[]  digest = null;
    chapPacketResponse[0] = (byte)MD5CHAP_RESPONSE; //MD5CHAP_RESPONSE;
    chapPacketResponse[1] = (byte)sessionID; //SessionID;

    //packet Length

    chapPacketResponse[2] = (byte)HI_BYTE(MD5CHAP_RESPONSE_PACKET_LENGTH); //hi Byte;
    chapPacketResponse[3] = (byte)LO_BYTE(MD5CHAP_RESPONSE_PACKET_LENGTH); //low Byte;

    chapPacketResponse[4] = (byte)MD5CHAP_RESPONSE_OCTECT_LENGTH; //value size

    String MD5String = PRNGChallange + password;
    digest = computeMD5(MD5String.getBytes());
    if (digest == null)
      return null;

    //append the MD5 value into the CHAP packet
    //byte [] byteDigest = digest.getBytes();
    int md5index = 5;
    for(int ii = 0; ii< digest.length; ii++,md5index++)
    {
      chapPacketResponse[md5index] = digest[ii];
    }
    //for Chinese use unicode  as the default encoding.
    //if not change it to visible characters, it will has the problem when visited by other systems.
    return new String(encode(chapPacketResponse));
    //return new String(chapPacketResponse);
  }


  public boolean extractCHAPPacket(String chapPacket){
   byte[] chapPacketBuff= chapPacket.getBytes();
   int packetLen = 0;
   byte hiByte = 0;
   byte lowByte = 0;

   byte chapCode = chapPacketBuff[0]; //chapcode
   sessionID = chapPacketBuff[1]; //sessionId

   //Compute Packet Length
   hiByte = chapPacketBuff[2]; //hi byte
   lowByte = chapPacketBuff[3]; //lo byte

   packetLen = FORM_WORD_FROM_BYTES(hiByte, lowByte);
   System.out.println("PacketLen = " + packetLen);

   //Value size
   byte PRNGValueSize = chapPacketBuff[4];

   //Values
   byte [] PRNGValue = new  byte[PRNGValueSize];
   byte PRNGValueStartIndex = 5;
   for(byte b = 0; b <PRNGValueSize ; b++)
     PRNGValue[b] =  chapPacketBuff[PRNGValueStartIndex++]; //8 bytes

   PRNGChallange = new String(PRNGValue);

   PRNGValue = null;
   chapPacketBuff = null;

   return true;
  }

  static private String hexDigit(byte x) {
      StringBuffer sb = new StringBuffer();
      char c;
      // First nibble
      c = (char) ((x >> 4) & 0xf);
      if (c > 9) {
        c = (char) ((c - 10) + 'a');
      } else {
        c = (char) (c + '0');
      }
      sb.append (c);
      // Second nibble
      c = (char) (x & 0xf);
      if (c > 9) {
        c = (char)((c - 10) + 'a');
      } else {
        c = (char)(c + '0');
      }
      sb.append (c);
      return sb.toString();
  }


  private byte[] computeMD5 (byte[] byteBuffer) {

      MessageDigest algorithm = null;
      try {
        algorithm = MessageDigest.getInstance("MD5");
      }
      catch (NoSuchAlgorithmException e) {
        System.out.println("Invalid algorithm");
        return null;
      }
      algorithm.reset();
      algorithm.update(byteBuffer);
      byte digest[] = algorithm.digest();
      return digest;
  }
}