/***************************************************************************
* CancelInfoApplet.java
*
* (C) Copyright 2009 SafeNet, Inc. All rights reserved.
*
*
* Description : Sentinel Protection Server.
*
* Purpose     : To display/cancel the license details for a attached key using licenseinfo.xml
*
****************************************************************************/

import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import javax.swing.*;
import java.util.*;
import java.io.*;
import java.net.*;
import java.security.*;
import java.awt.AWTPermission;


/**
*The Applet to display the license information
*/
public class CancelInfoApplet extends Applet  implements ActionListener{
//file to request from server for license details
  static public final String LICENSE_INFO_XML_FILE = "licenseinfo.xml";

  ResourceBundle resourceBundle;
  //boolean variable for check the resource bundle
  boolean   isResourceBundleFound = false;

  JPanel mCenterPanel = new JPanel();
  JPanel mSouthPanel = new JPanel();
  JPanel mNorthPanel = new JPanel();



  JLabel LicLine1Heading = new JLabel();
  JLabel LicAddStaticLabel = new JLabel();
  Label mLicTopHeadingLabel = new Label();
  JLabel LiclblError = new JLabel();
  JTextArea mLicFootNoteLabel = new JTextArea();
  Label mCopyrightLabel = new Label();

  CancelLicenseRow headingRow = new CancelLicenseRow(true);

  String tmpString = new String();
  String xmlBuffer = new String("");
  Vector vLicenseRow = new Vector(2, 1);
  Vector tmpVector = new Vector(2, 1);

  Vector licenseIdVector = new Vector(2, 1);

  CancelLicenseRow kKeysDetails;
  JButton mBack = new JButton();
  JButton mDelete = new JButton();
  CPasswordDlg pwdDialog = new CPasswordDlg();

  GridBagLayout gridBagLayout1 = new GridBagLayout();
  GridBagLayout gridBagLayoutNorth = new GridBagLayout();
  Color lblColor, borderColor;

  //URL of the server
  URL codeBase;
  String keyIndex;
  String keySerialNumber;
  //password from the
  String password = null;

  String MinErrorMsgStr = new String("Please select the licenses to be canceled.");
  String MaxErrorMsgStr = new String("You cannot cancel more than 10 licenses in one attempt.");
  GridBagLayout gridBagLayout2 = new GridBagLayout();
  GridBagLayout gridBagLayout3 = new GridBagLayout();
   
  //for refresh
  static int count = 0;
  
  private void setAppletCodeBase()
  {
    try {
      codeBase = getCodeBase();
    } catch (Exception ex) {
      ex.printStackTrace();
    }
  }


  //Construct the applet
  public CancelInfoApplet() {
  }

  //Initialize the applet
  public void init() {
    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /**
  * Method to pad the serial number.
  */
    static public String PadSerialNumber(int input) {

      int width = 8; //pad for 8 digit wide
      //convert the serial number into the hex to display
      String output = Integer.toHexString(input);
      //convert to uppercase
      output = output.toUpperCase();

      for (int i = width - output.length(); i > 0; i--) {
        output = "0" + output;
      }
      //prefix it with the 0x
      output = "0x" + output;
      return output;
    }

  /**
   *Function to fill the data into the rows
   */
  private void fillRow(int iTotalKeysDetails) {
    XMLParser xParser = new XMLParser();
    try {
      CancelLicenseRow tmpLicenseRow = new CancelLicenseRow();
      tmpVector = xParser.getXMLTagValue(xmlBuffer, "ClientIPAddress");
      for (int k = 0; k < iTotalKeysDetails; k++) {
        tmpLicenseRow = (CancelLicenseRow) vLicenseRow.get(k);
        String s = tmpVector.elementAt(k).toString();
        tmpLicenseRow.lblClientIP.setText(s);
      }

      tmpVector = xParser.getXMLTagValue(xmlBuffer, "ClientUserName");
      if (!tmpVector.isEmpty()) {
        for (int k = 0; k < iTotalKeysDetails; k++) {
          tmpLicenseRow = (CancelLicenseRow) vLicenseRow.get(k);
          tmpLicenseRow.lblClientUserName.setText(tmpVector.elementAt(k).
                                                  toString());

        //Does allow user to Cancel the license obtained in Driver Mode.
         if(tmpVector.elementAt(k).toString().equalsIgnoreCase("DRIVER MODE")){
            tmpLicenseRow.chkDelete.setEnabled(false);
            tmpLicenseRow.chkDelete.setVisible(false);
         }
        }
      }

      tmpVector = xParser.getXMLTagValue(xmlBuffer, "ClientLogTime");
      for (int k = 0; k < iTotalKeysDetails; k++) {
        tmpLicenseRow = (CancelLicenseRow) vLicenseRow.get(k);
        tmpLicenseRow.lblClientLogTime.setText(tmpVector.elementAt(k).toString());
      }

      tmpVector = xParser.getXMLTagValue(xmlBuffer, "ClientProcessID");
      for (int k = 0; k < iTotalKeysDetails; k++) {
        tmpLicenseRow = (CancelLicenseRow) vLicenseRow.get(k);
        tmpLicenseRow.lblClientPID.setText(tmpVector.elementAt(k).toString());
      }

      tmpVector = xParser.getXMLTagValue(xmlBuffer, "LicenseID");
      for (int k = 0; k < iTotalKeysDetails; k++) {
        tmpLicenseRow = (CancelLicenseRow) vLicenseRow.get(k);
        String tempS = tmpVector.elementAt(k).toString();
        tmpLicenseRow.licenseID = tempS;
      }

      //Add the keys row panel in the mCenterPanel
      for (int k = 0, j = 1; k < iTotalKeysDetails; k++, j++) {
        mCenterPanel.add(( (CancelLicenseRow) vLicenseRow.get(k)),     new GridBagConstraints(0, j, 1, 1, 1.0, 0.0
        ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
        if ((k == (iTotalKeysDetails-1)) && (iTotalKeysDetails < 10)) {
        mCenterPanel.add(new JPanel(),     new GridBagConstraints(0, j, 1, 1, 1.0, 1.0
        ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
        }

      }


    }
    catch (Exception ex) {

    }
  }

  /**
   *Applet initialization method
   */
  private void jbInit() throws Exception {
    if ( System.getProperty("os.name").indexOf("Mac") != -1)
    {
      lblColor = new Color(0,0,90);
      borderColor = new Color(0,0,90);
    }
    else if (( System.getProperty("os.name").indexOf("Vista") != -1) || (System.getProperty("os.name").indexOf("Windows 7") != -1))
    {
      lblColor = new Color(0,0,90);
      borderColor = new Color(0,0,90);
    }
    else{
      lblColor = SystemColor.activeCaption;
      borderColor = Color.lightGray;
    }

    String mLicFootNoteLabelStr = new String("Cannot display login time and process ID for the clients using Sentinel driver-based access modes (like SP_DRIVER_MODE for UltraPro clients and RNBO_SPN_DRIVER for SuperPro clients; these modes do not require Sentinel Protection Server to access the keys). The licenses issued to such clients cannot be canceled in Sentinel License Monitor.");
    String LicAddStaticLabelStr = new String("Serial Number: ");
    String LiclblErrorStr = new String("No License details available.");
    String XMLFileErrorStr = new String("Error in downloading the license information file.");
    JScrollPane mScrollPane = new JScrollPane();
    try{
      resourceBundle = ResourceBundle.getBundle("AppletResources");
      //make a check if the resource bundle is present
      String testString = resourceBundle.getString("key");
      isResourceBundleFound = true;
    }catch (MissingResourceException e){
      isResourceBundleFound = false;
    }catch (NullPointerException en){
      isResourceBundleFound = false;
    }
    //check if the resource bundle is found
    if(isResourceBundleFound == true)
    {
      mLicTopHeadingLabel.setText(resourceBundle.getString("mLicTopHeadingLabel"));
      LicLine1Heading.setText(resourceBundle.getString("LicLine1Heading"));
      mCopyrightLabel.setText(resourceBundle.getString("mCopyrightLabel"));
      mBack.setText(resourceBundle.getString("mBack"));
      mDelete.setText(resourceBundle.getString("mDelete"));
      LicAddStaticLabelStr = resourceBundle.getString("LicAddStaticLabel");
      LiclblErrorStr = resourceBundle.getString("LiclblError");
      XMLFileErrorStr = resourceBundle.getString("XMLLicFileError");
      MinErrorMsgStr = resourceBundle.getString("Min_Error_Msg");
      MaxErrorMsgStr = resourceBundle.getString("Max_Error_Msg");

    }else{
      mLicTopHeadingLabel.setText("License Usage for the Key");
      LicLine1Heading.setText("Following are the usage details of each license available with key.");
      mCopyrightLabel.setText("Copyright (c)2009 SafeNet, Inc.");
      mBack.setText("Back");
      mDelete.setText("Cancel License Session");
    }

    //set applet codebase
    setAppletCodeBase();

    this.setLayout(gridBagLayout2);
    mLicTopHeadingLabel.setBackground(lblColor);
    mLicTopHeadingLabel.setFont(new java.awt.Font("Serif", 1, 24));
    mLicTopHeadingLabel.setForeground(Color.white);

    LicAddStaticLabel.setBackground(Color.white);
    LicAddStaticLabel.setFont(new java.awt.Font("Serif", 1, 15));
    LicAddStaticLabel.setForeground(lblColor);
    mCenterPanel.setLayout(gridBagLayout3);
    LicLine1Heading.setBackground(Color.white);
    LicLine1Heading.setFont(new java.awt.Font("Serif", 1, 14));
    LicLine1Heading.setForeground(lblColor);

    //The * is the mark for footnote.
    String footNote = new String("* ");
    footNote = footNote + mLicFootNoteLabelStr; //add footnote after *
    mLicFootNoteLabel.setText(footNote);
    mLicFootNoteLabel.setLineWrap(true);
    mLicFootNoteLabel.setWrapStyleWord(true);

    mLicFootNoteLabel.setBackground(Color.white);
    mLicFootNoteLabel.setFont(new java.awt.Font("Serif", 0, 12));
    mLicFootNoteLabel.setForeground(new Color(0, 0, 90));
    mLicFootNoteLabel.setEditable(false);
    mLicFootNoteLabel.setMinimumSize(new Dimension(30, 40));
    mLicFootNoteLabel.setMaximumSize(new Dimension(30, 40));
    mLicFootNoteLabel.setPreferredSize(new Dimension(30, 40));

    mCopyrightLabel.setBackground(Color.white);
    mCopyrightLabel.setFont(new java.awt.Font("Serif", 0, 14));
    mCopyrightLabel.setForeground(new Color(0, 0, 90));

    mBack.setMinimumSize(new Dimension(90, 25));
    mBack.setPreferredSize(new Dimension(90, 25));
    mBack.addActionListener(this);
    mBack.setVisible(true);

    mDelete.setMinimumSize(new Dimension(180, 25));
    mDelete.setPreferredSize(new Dimension(180, 25));
    mDelete.setVisible(true);
    mDelete.addActionListener(this);

    LiclblError.setBackground(Color.white);
    LiclblError.setFont(new java.awt.Font("Serif", 1, 14));
    LiclblError.setForeground(Color.red);
    LiclblError.setVisible(false);
    this.setBackground(Color.white);
    this.setForeground(Color.white);
    mCenterPanel.setBackground(Color.white);
    mCenterPanel.setForeground(Color.black);
    mSouthPanel.setBackground(Color.white);
    mSouthPanel.setLayout(gridBagLayout1);

    mNorthPanel.setLayout(gridBagLayoutNorth);
    mNorthPanel.setBackground(Color.white);

    mScrollPane.setMaximumSize(new Dimension(500, 501));
    mScrollPane.setMinimumSize(new Dimension(500, 501));
    mScrollPane.setPreferredSize(new Dimension(500, 501));
    mCenterPanel.add(headingRow,     new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0
   ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));


    mSouthPanel.add(mLicFootNoteLabel,
                             new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    mSouthPanel.add(mCopyrightLabel,
                     new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
    mSouthPanel.add(mBack,  new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));

    mSouthPanel.add(mDelete,  new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.NORTHWEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));

    mSouthPanel.setVisible(true);

    this.add(mScrollPane,           new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0
            ,GridBagConstraints.NORTH, GridBagConstraints.BOTH, new Insets(17, 5, 15, 5), 0, 0));
    mScrollPane.getViewport().add(mCenterPanel, null);
    mScrollPane.setBorder(BorderFactory.createEmptyBorder());
    this.add(mSouthPanel,         new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0
            ,GridBagConstraints.SOUTH, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    this.add(mNorthPanel,       new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.SOUTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));

    mNorthPanel.add(mLicTopHeadingLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
    mNorthPanel.add(LicAddStaticLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
    mNorthPanel.add(LicLine1Heading, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
    mNorthPanel.add(LiclblError, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));

    //Request for the licenseinfo.xml file to server
    try {
      String inputLine;

      URL rURL = new URL(getCodeBase() + this.LICENSE_INFO_XML_FILE);

      BufferedReader in = new BufferedReader(
          new InputStreamReader(
          rURL.openStream()));

      //get the contents of xml file in the buffer
      while ( (inputLine = in.readLine()) != null)
        xmlBuffer = xmlBuffer + inputLine;

      in.close(); //close the BufferReader
      count = 0;
      XMLParser xParser = new XMLParser();

      //get the serial number from the licenseinfo file to display.
      tmpVector = xParser.getXMLTagValue(xmlBuffer, "SerialNumber");

      String finalSerialNumberToDisplay;
      keySerialNumber = tmpVector.elementAt(0).toString();
      String strSerialNumber = keySerialNumber;
      //get the serial number in decimal
      int iSerialNumber = Integer.parseInt(strSerialNumber);
      //pad the serial number to displays
      strSerialNumber = PadSerialNumber(iSerialNumber);

      finalSerialNumberToDisplay = LicAddStaticLabelStr + strSerialNumber;
      LicAddStaticLabel.setText(finalSerialNumberToDisplay);

      //get the keyIndex from the licenseinfo file.
      tmpVector = xParser.getXMLTagValue(xmlBuffer, "KeyIndex");
      keyIndex = tmpVector.elementAt(0).toString();

      //get the number of keys Info in file
      tmpVector = xParser.getXMLTagValue(xmlBuffer, "LicenseDetails");
      if (tmpVector.isEmpty()) {
        //Give the message for no keys details found in the xml file.
        LiclblError.setText(LiclblErrorStr);
        LiclblError.setVisible(true);
        mCenterPanel.add(new JPanel(),     new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
          ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
        return;
      }
      //Get the total number of keys
      int iTotalKeysDetails = 0;

      iTotalKeysDetails = tmpVector.size();
      //Manipulation with the rowss
      for (int k = 0; k < iTotalKeysDetails; k++) {
        kKeysDetails = new CancelLicenseRow();
        vLicenseRow.add(kKeysDetails);
      }

         fillRow(iTotalKeysDetails);

    }
    catch (Exception ex)
    {
       if (xmlBuffer.length() == 0)
       {
          if (count < 5)
          {
             Thread.sleep(500);
             count++;
             getAppletContext().showDocument(getDocumentBase());
             return;
          }
       }
       
      LiclblError.setText(XMLFileErrorStr);
      LiclblError.setVisible(true);
        mCenterPanel.add(new JPanel(),     new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
          ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));


    }
  }

  //Start the applet
  public void start() {
  }

  //Stop the applet
    public void stop() {
    }
    //Destroy the applet
    public void destroy() {
    }

  void goBack()
  {
    try {
      System.out.println(codeBase);
      getAppletContext().showDocument(codeBase);
    }
    catch (Exception ex) {
      ex.printStackTrace();
    }
}

  void mBack_actionPerformed(ActionEvent e) {
    goBack();
  }

  /**
   */
  void mDelete_actionPerformed(ActionEvent e) {
    URL codeBase;
    codeBase = getCodeBase();
   licenseIdVector.clear();

    if (!vLicenseRow.isEmpty()) {
      for (int k = 0; k < vLicenseRow.size(); k++) {
        boolean b = ((CancelLicenseRow) vLicenseRow.elementAt(k)).chkDelete.isSelected();
        if (b) {
          licenseIdVector.addElement(((CancelLicenseRow) vLicenseRow.elementAt(k)).licenseID);
        }
      }
    }

    if (licenseIdVector.isEmpty() == true) {
      JOptionPane.showMessageDialog(this, MinErrorMsgStr);
      return;
    }
    /*
      Only 10 license can be Cancel at a time.
    */
    if(licenseIdVector.size() > 10) {
       JOptionPane.showMessageDialog(this, MaxErrorMsgStr);
    return;
    }

   //Get the password
   pwdDialog.setVisible(true);
   //get the password if user has clicked ok otherwise do nothing
   if (pwdDialog.state == 1) { //ok
     password = pwdDialog.getPassword();
     //Communicate to the server and send the Cancel request
     deleteLicense();
   }
   //Clear the vector
   licenseIdVector.clear();
  }


  /**
   *
   * @param inMsg
   * @param outMsg
   * @return
   */
void constructCHAPPacket(){
    StringBuffer chapBuffer = new StringBuffer();
//    chapBuffer.append(CMessage.MD5_ALGO_ID)
  }

  /**
     *
     */
  boolean parseAndProcessMessage(String inMsg, StringBuffer outMsg){
    CMessage tempObj = new CMessage();
    Vector vLevel1Message = null;
    Vector vLevel2Message = null;

    StringBuffer tempBuffer = new StringBuffer();

    int msgID = 0;
    int i     = 0;
    //The session Handle send by the server in step2
    String sessionHandle = new String();

    if(tempObj.isError(CMessage.LEVEL1_SEP, inMsg) == true){
      System.out.println("parseAndProcessMessage error:");
      return false;
    }else{
      //get the level 1 msg
      vLevel1Message = tempObj.splitMessage(CMessage.LEVEL1_SEP,inMsg);
      msgID = Integer.parseInt(vLevel1Message.elementAt(0).toString());

      switch(msgID)
      {

/*
server send the following message
if error
         ?##LIC_HELLO###error######


if success
         ?##LIC_HELLO###success###level-2message###

         Level-2 message (6 fields)-
         ?!!sessionHandle!!!numProtocols!!!level3msg1!!!numAlgos!!!level3msg2!!!ServerVersion!!!

         Level-3 message 1
         ?$$Prot1$$$Prot2$$$?.$$$Protn$$$

         Level-3 message 2
         ?$$Algo1$$$Algo2$$$?.$$$Algon$$$

*/
        case 40: //LIC_HELLO
          //get the level 2 msg
          //parse the message for the available algorithms
          //write code here for parsing the packet and the available algorithms
          //just assume that one MD5 is available here only.
          //do here
          vLevel2Message = tempObj.splitMessage(CMessage.LEVEL2_SEP,vLevel1Message.elementAt(2).toString());
          //extract the session handle
          sessionHandle = vLevel2Message.elementAt(0).toString();
          System.out.println("session handle"+sessionHandle);
          //Now construct the message to send the server
          //remove the elements of vector
          if(!vLevel2Message.isEmpty()){
            for (i = 0; i < vLevel2Message.size(); i++)
              vLevel2Message.removeElementAt(i);
          }
          if(!vLevel1Message.isEmpty()){
            for(i = 0; i< vLevel1Message.size(); i++)
              vLevel1Message.removeElementAt(i);
          }

          //construct the level-2 message
          Vector tempVector = new Vector(2,1);

          tempVector.addElement(sessionHandle);
          tempVector.addElement(CMessage.CHAP_PROTOCOL_ID);
          tempVector.addElement(CMessage.MD5_ALGO_ID);

          tempBuffer.append(tempObj.constructMessage(CMessage.LEVEL2_SEP, tempVector));
          tempVector = null;

          //construct the level-1 message
          Vector tempVector2 = new Vector(2,1);
          tempVector2.addElement(CMessage.LIC_DELETE);
          tempVector2.addElement(tempBuffer.toString());
          tempVector2.addElement("");
          //delete the string buffer
          tempBuffer.delete(0, tempBuffer.length());

          tempBuffer.append(tempObj.constructMessage(CMessage.LEVEL1_SEP, tempVector2));
          tempVector2 = null;

          outMsg.append(tempBuffer.toString());

          break;

/*
           If server does not find the requested DLL, it sends an error in a level-1 message, described below
           ?##LIC_DELETE###error######

           The last field would be empty (we don't have to send the error code to the user).
           Else, server sends the CHAP packet (containing random number) and the handle value to the web tool in a two level message described as follows:
           ?##LIC_DELETE ###success###level-2message###


           The level-2 message field will have two fields and is described as follows-
           ?!!sessionHandle!!!CHAP packet!!!


*/
        case 41: //LIC_DELETE
          //get the level 2 msg
          vLevel2Message = null;
          vLevel2Message = tempObj.splitMessage(CMessage.LEVEL2_SEP,vLevel1Message.elementAt(2).toString());
          //extract the session handle
          sessionHandle = vLevel2Message.elementAt(0).toString();
//extract chap packet
          String chapPacket = vLevel2Message.elementAt(1).toString();
          byte[] chapPacketBuff= chapPacket.getBytes();

          //extract the CHAP packet
          CMd5Chap md5Chap = new CMd5Chap();

          md5Chap.extractCHAPPacket(chapPacket); //check for failure

          //form md5 chap packet
          String chapResponse = md5Chap.formChapPacket(password);
          if (chapResponse == null) {
            //failre case -  failure pkt should be returned
          }


/*
//calculate the MD5

            MessageDigest algorithm = null;
            String MD5String = null;
            MD5String = "abc" + password + PRNGValue;

            String  digest = computeMD5(algorithm, MD5String );
            System.out.println(digest);
*/


/*
           Web tool sends password hash, handle value and license Ids to the server in a three-level message described as follows-
           Level-1 message (third field is empty here)
            ?##NSPRO_DEL_LIC_RESPONSE###level-2 message######

           Level-2 message (number of fields 6)
           !!!sessionHandle!!!CHAPpacket!!!keyIndex!!!keySerialNumber!!!numLicIds!!!level3message!!!


           Level-3 message (number of fields will be sent in the third field of the level-2 message described above)-
           ?$$LicId1$$$LicId2$$$LicId3$$$..$$$LicIdn$$$


*/
          //delete the string buffer
          tempBuffer.delete(0, tempBuffer.length());

          //level -3 message
          tempBuffer.append(tempObj.constructMessage(CMessage.LEVEL3_SEP, licenseIdVector));
          System.out.println("step 5 level 3: " + tempBuffer);

          //construct the level-2 message
          Vector tempV = new Vector(2,1);

          tempV.addElement(sessionHandle);
//construct the chap packet

          tempV.addElement(chapResponse);
          tempV.addElement(keyIndex);
          tempV.addElement(keySerialNumber);

          int numLicIDs = licenseIdVector.size();
          String temp = new String();
          temp = Integer.toString(numLicIDs);

          tempV.addElement(temp);
          tempV.addElement(tempBuffer.toString());  //level-3 message

          tempBuffer.delete(0,tempBuffer.length());
          tempBuffer.append(tempObj.constructMessage(CMessage.LEVEL2_SEP, tempV));
          tempV = null;
          System.out.println("step 5 level 2: " + tempBuffer);

          //construct the level-1 message
          tempV = new Vector(2,1);
          tempV.addElement(CMessage.LIC_DELETE_RESPONSE);
          tempV.addElement(tempBuffer.toString());
          tempV.addElement("");

          tempBuffer.delete(0,tempBuffer.length());
          tempBuffer.append(tempObj.constructMessage(CMessage.LEVEL1_SEP, tempV));
          outMsg.append(tempBuffer.toString());
          System.out.println("step5 going to send" + tempBuffer.toString());
          break;


        case 42: //LIC_DELETE_RESPONSE
          //No need to do anything
          break;

        default: //in case of default return error
          return false;

      }
      return true;
    }

  }

  /**
   *
   */

  StringBuffer formHelloMessage(){
    CMessage tempObj = new CMessage();
    Vector msgVec = new Vector(2,1);
    StringBuffer msg = new StringBuffer();
    //construct the level-1 message hello message
    msgVec.addElement(CMessage.LIC_HELLO);
    msgVec.addElement(CMessage.CLIENT_VER);
    msgVec.addElement("");
    msg.append(tempObj.constructMessage(CMessage.LEVEL1_SEP, msgVec));
    tempObj = null;
    System.out.println("Vmittal = :" + msg);
    return msg;
  }


  /**
   *
   */
  void deleteLicense() {
    boolean isContinue = true;
    CMessage connect1 = new CMessage();
    StringBuffer msgStr = new StringBuffer();

    StringBuffer outMsg = new StringBuffer();

    try {
      //step 1
      //construct the hello message

      msgStr.append(formHelloMessage().toString());
      //open the socket
      connect1.open(codeBase);
      //send the hello message to server
      connect1.send(msgStr.toString());
      System.out.println("step1 after send = :" + msgStr);

      //step 2
      //Receive the message from server
      msgStr.delete(0,msgStr.length());
      msgStr.append(connect1.recv());

      System.out.println("step2 after recv = :" + msgStr);

      //parse the request and if error then fo the back page
      isContinue = parseAndProcessMessage(msgStr.toString(), outMsg);
      if(!isContinue){
        System.out.println("step2 after recv, case of error");
        connect1.close();
        goBack();
        return;
      }

      //close the connection and open the socket for next communication
      connect1.close();

     //step 3
     connect1.open(codeBase);
     System.out.println("step3 going to send1" + outMsg.toString());
     //send step preferred algo and ..
     connect1.send(outMsg.toString());
     System.out.println("step3 after send = :" + outMsg);

     //step - 4
     //read message
     msgStr.delete(0,msgStr.length());
     msgStr.append(connect1.recv());
     System.out.println("step4 recv = :" + msgStr);
     //parse the request and if error then fo the back page
     isContinue = true; //reinitialize
     outMsg.delete(0,outMsg.length());

     isContinue = parseAndProcessMessage(msgStr.toString(), outMsg);
     if(!isContinue){
       System.out.println("step4 after recv, case of error");
       connect1.close();
       goBack();
       return;
     }

     //close
     connect1.close();

    //step - 5
    connect1.open(codeBase);
    connect1.send(outMsg.toString());
    System.out.println("step5 after send = :" + outMsg);

    //parse the response and if error then for the back page
    //read message
    msgStr.delete(0,msgStr.length());
    msgStr.append(connect1.recv());

    System.out.println("step5 recv = :" + msgStr);
    //parse the request and if error then fo the back page
    isContinue = true; //reinitialize
    outMsg.delete(0,outMsg.length());

    isContinue = parseAndProcessMessage(msgStr.toString(), outMsg);
    if(!isContinue){
      System.out.println("step6 after recv, case of error");
      connect1.close();
      goBack();
      return;
    }

    connect1.close();
    //go to the keyinfo page
    goBack();

  } catch (SecurityException  e) {
      System.out.println("SecurityException: " + e);
      //in case of error go to the back
      goBack();
    }
  }

  /**
   *
   * Action listener for buttons
   */
  public void actionPerformed(ActionEvent e) {
    this.Btn_actionPerformed(e);
}

  void Btn_actionPerformed(ActionEvent e) {
    if(e.getSource().equals(mDelete))
     mDelete_actionPerformed(e);
    if(e.getSource().equals(mBack))
      mBack_actionPerformed(e);
  }
}

/**
* Class to represent a row of the key details
*/
class CancelLicenseRow extends JPanel {
  ResourceBundle            resourceBundle;
  boolean   isResourceBundleFound = false;
  JCheckBox chkDelete        = new JCheckBox();
  JLabel lblDelete           = new JLabel();
  JLabel lblClientIP        = new JLabel();
  JLabel lblClientUserName  = new JLabel();
  JLabel lblClientLogTime   = new JLabel();
  JLabel lblClientPID       = new JLabel();
  //licenseID for the particular license used to Cancel the license.
  String licenseID;
  GridLayout gridBagLayout1 = new GridLayout();
  Color lblColor, borderColor;

/** The constructor
   *  Construct the header row, if header is true
   */
  public CancelLicenseRow(boolean header) {
    try {
      jbInit(header);
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

/**
* Default constructor
   * It construct the row as
*/
  public CancelLicenseRow() {
    try {
      boolean header = false;
      jbInit(header);
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit(boolean header) throws Exception {
    try{
      if ( System.getProperty("os.name").indexOf("Mac") != -1)
      {
        lblColor = new Color(0,0,90);
        borderColor = new Color(0,0,90);
      }
      else if (( System.getProperty("os.name").indexOf("Vista") != -1) || (System.getProperty("os.name").indexOf("Windows 7") != -1))
      {
        lblColor = new Color(0,0,90);
        borderColor = new Color(0,0,90);
      }
      else{
        lblColor = SystemColor.activeCaption;
        borderColor = Color.lightGray;
      }

      resourceBundle = ResourceBundle.getBundle("AppletResources");
      //check if the resource bundle is present
      String testString = resourceBundle.getString("key");
      isResourceBundleFound = true;
    }catch (MissingResourceException e){
      isResourceBundleFound = false;
    }catch (NullPointerException en){
      isResourceBundleFound = false;
    }

    if(isResourceBundleFound == true)
    {
      lblClientIP.setText(resourceBundle.getString("lblClientIP"));
      lblClientUserName.setText(resourceBundle.getString("lblClientUserName"));
      lblClientLogTime.setText(resourceBundle.getString("lblClientLogTime"));
      lblClientPID.setText(resourceBundle.getString("lblClientPID"));
      lblDelete.setText(resourceBundle.getString("lblDelete"));
    }else{
      lblClientIP.setText("Client/Access Mode");
      lblClientUserName.setText("User Name");
      lblClientLogTime.setText("Client Login Time");
      lblClientPID.setText("Client Process ID");
      lblDelete.setText("Cancel");
    }

    this.setLayout(gridBagLayout1);


    JPanel tempPanel = new JPanel();
    //if header is true then make the header row
    if(header) {
      this.add(lblDelete,     new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0
        ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));

    }
    else {
      this.add(tempPanel,     new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0
     ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));

      tempPanel.add(chkDelete, null);
    }

    chkDelete.setEnabled(true);
    chkDelete.setBackground(Color.white);
    tempPanel.setBackground(Color.white);
    this.setBackground(Color.white);
    tempPanel.setBorder(BorderFactory.createLineBorder(borderColor));


    lblDelete.setBorder(BorderFactory.createLineBorder(borderColor));
    lblDelete.setFont(new java.awt.Font("Serif", 1, 16));
    lblDelete.setForeground(lblColor);
    lblDelete.setHorizontalAlignment(SwingConstants.CENTER);


    this.add(lblClientIP,     new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0
  ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));


    lblClientIP.setHorizontalAlignment(SwingConstants.CENTER);
     this.add(lblClientUserName,     new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0
  ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));

    lblClientUserName.setHorizontalAlignment(SwingConstants.CENTER);

    this.add(lblClientLogTime,     new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0
  ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));

    lblClientLogTime.setHorizontalAlignment(SwingConstants.CENTER);

    this.add(lblClientPID,     new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0
   ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));

    lblClientPID.setHorizontalAlignment(SwingConstants.CENTER);

    lblClientIP.setBorder(BorderFactory.createLineBorder(borderColor));
    lblClientIP.setFont(new java.awt.Font("Serif", 1, 16));
    lblClientIP.setForeground(lblColor);
    lblClientUserName.setBorder(BorderFactory.createLineBorder(borderColor));
    lblClientUserName.setFont(new java.awt.Font("Serif", 1, 16));
    lblClientUserName.setForeground(lblColor);
    lblClientLogTime.setBorder(BorderFactory.createLineBorder(borderColor));
    lblClientLogTime.setFont(new java.awt.Font("Serif", 1, 16));
    lblClientLogTime.setForeground(lblColor);
    lblClientPID.setBorder(BorderFactory.createLineBorder(borderColor));
    lblClientPID.setFont(new java.awt.Font("Serif", 1, 16));
    lblClientPID.setForeground(lblColor);
  }
}
