c
c THIS IS THE GEOMETRY FILE FOR THE TUTORIAL EXAMPLE 'dblbtrf'
c
c The Geometry for this problem was creating using a
c boot-strapping process:
c   1. 2D curves are created that are to be the
c      cross sections of an elbow pipe, as well
c      as the curve along which the cross sections
c      are placed.
c   2. A swept surface is created using the curves
c      generated in step 1.  A plane which is to be
c      a symmetry plane is created.  A second intersecting
c      cylindrical pipe is created.
c   3. Several curves were extracted directly from
c      contours of the resulting surfaces.  These
c      curves were then generated by TrueGrid (used
c      the CONTOUR option of the SD command).
c   4. Some of the extracted curves were used to create
c      RULED SURFACES (between the curves).
c   5. Some Intersection curves were created using the
c      mesh generator.  The edges of a shell were projected
c      to the intersection.  The shell was converted to a
c      surface, and an edge was extracted.
c
c create required curves
c ----------------------
  ld 1
    lp2              c list 2d points
      0 0
      2 0;
    lep              c append an ellipt arc
      1 1                 c lengths of major, minor axes
      2 1                 c center of the arc
     -90 0                c range of angles
      0                   c angle between major axis and the x-axis
    lp2                   c add more 2d points
      3 3;
    ;                c end of definition
  ld 2
    lep .5 .5 0 0 0 180 0 ;   c another elliptic arc
  ld 3
    lep .25 .25 0 0 0 180 0 ; c yet another elliptic arc
c
c create required surfaces
c ------------------------
  sd 1 swept         c swept curve - elbow pipe
    1                     c sweeping curve number
    l                     c sweep on the left side of sweeping curve
    2                     c number of 2d curve to be swept
    0                     c relative arg length position
    3                     c number of 2d curve to be swept
    1                     c relative arc length position
    ;                     c end list of sweeping curves
    rx 90;                c rotate the entire curve about the x-axis
  sd 2 cy            c cylinder    - intersection pipe
    0 0 0                 c point on the axis of the cylinder
    1 0 0                 c direction vector of axis
   .1                     c radius
  sd 3 plan          c plane       - symmetry plane
    0 0 0                 c point on the plane
    0 0 1                 c normal to the plane
c
c LIST OF CURVES
c
c     1, 2 - for butterfly
c     3, 4, 5, 6 - for ruled surface
c     7, 8 - lower side curves (for ruled surface
c     9, 10 - surface edges
c
curd 1 lp3
       0.0  0.3078308  0.3940053
 2.0000000  0.2513299  0.3242317
 2.0436363  0.2495821  0.3230140
 2.0871508  0.2463143  0.3217962
 2.1304905  0.2415328  0.3205784
 2.1736021  0.2352460  0.3193606
 2.2164352  0.2274636  0.3181429
 2.2589357  0.2181980  0.3169251
 2.3010545  0.2074622  0.3157074
 2.3427391  0.1952721  0.3144896
 2.3839397  0.1816448  0.3132718
 2.4246078  0.1665989  0.3120541
 2.4646933  0.1501553  0.3108363
 2.5041487  0.1323363  0.3096185
 2.5429275  0.1131656  0.3084008
 2.5809836  0.0926684  0.3071830
 2.6182692  0.0708735  0.3059652
 2.6547430  0.0478075  0.3047475
 2.6903613  0.0235010  0.3035297
 2.7250807 -0.0020136  0.3023119
 2.7588613 -0.0287035  0.3010942
 2.7916629 -0.0565345  0.2998764
 2.8234465 -0.0854702  0.2986587
 2.8541775 -0.1154754  0.2974409
 2.8838170 -0.1465092  0.2962231
 2.9123318 -0.1785334  0.2950054
 2.9396899 -0.2115081  0.2937876
 2.9658589 -0.2453910  0.2925698
 2.9908073 -0.2801369  0.2913521
 3.0145092 -0.3157058  0.2901343
 3.0369375 -0.3520525  0.2889165
 3.0580637 -0.3891275  0.2876988
 3.0778682 -0.4268890  0.2864810
 3.0963266 -0.4652873  0.2852632
 3.1134186 -0.5042748  0.2840455
 3.1291265 -0.5438042  0.2828277
 3.1434333 -0.5838256  0.2816100
 3.1563234 -0.6242895  0.2803922
 3.1677828 -0.6651442  0.2791744
 3.1778011 -0.7063432  0.2779567
 3.1863673 -0.7478302  0.2767389
 3.1934743 -0.7895598  0.2755211
 3.1991150 -0.8314766  0.2743034
 3.2032852 -0.8735308  0.2730856
 3.2059822 -0.9156711  0.2718678
 3.2072051 -0.9578450  0.2706501
 3.1504538 -3.0000000  0.1996587 ;
 ; ;
curd 2 lp3
       0.0 -0.3078306  0.3940055
 2.0000000 -0.2537984  0.3223031
 2.0260751 -0.2533105  0.3210517
 2.0521839 -0.2537346  0.3198003
 2.0782948 -0.2550726  0.3185488
 2.1043763 -0.2573251  0.3172974
 2.1303949 -0.2604913  0.3160460
 2.1563208 -0.2645703  0.3147945
 2.1821191 -0.2695586  0.3135431
 2.2077606 -0.2754530  0.3122917
 2.2332120 -0.2822483  0.3110403
 2.2584412 -0.2899383  0.3097888
 2.2834182 -0.2985160  0.3085374
 2.3081107 -0.3079731  0.3072860
 2.3324878 -0.3183000  0.3060345
 2.3565183 -0.3294858  0.3047831
 2.3801744 -0.3415206  0.3035316
 2.4034228 -0.3543899  0.3022802
 2.4262354 -0.3680802  0.3010288
 2.4485838 -0.3825777  0.2997774
 2.4704392 -0.3978661  0.2985260
 2.4917729 -0.4139286  0.2972745
 2.5125582 -0.4307480  0.2960231
 2.5327668 -0.4483036  0.2947717
 2.5523751 -0.4665784  0.2935202
 2.5713561 -0.4855503  0.2922688
 2.5896840 -0.5051971  0.2910174
 2.6073358 -0.5254969  0.2897660
 2.6242898 -0.5464288  0.2885145
 2.6405206 -0.5679650  0.2872631
 2.6560068 -0.5900809  0.2860117
 2.6707308 -0.6127549  0.2847602
 2.6846693 -0.6359557  0.2835088
 2.6978049 -0.6596588  0.2822574
 2.7101190 -0.6838360  0.2810059
 2.7215946 -0.7084580  0.2797545
 2.7322159 -0.7334960  0.2785031
 2.7419674 -0.7589204  0.2772517
 2.7508359 -0.7847028  0.2760003
 2.7588067 -0.8108081  0.2747488
 2.7658701 -0.8372109  0.2734974
 2.7720132 -0.8638737  0.2722460
 2.7772276 -0.8907686  0.2709946
 2.7815042 -0.9178614  0.2697431
 2.7848353 -0.9451193  0.2684917
 2.7872150 -0.9725104  0.2672403
 2.8426700 -3.0000000  0.1942864 ;
 ; ;
curd 3 lp3
       0.0  0.1545092  0.4755280
 2.0000000  0.1252795  0.3906379
 2.0392537  0.1240842  0.3891563
 2.0784245  0.1215206  0.3876747
 2.1174638  0.1175931  0.3861931
 2.1563244  0.1123076  0.3847115
 2.1949599  0.1056720  0.3832299
 2.2333221  0.0976955  0.3817483
 2.2713661  0.0883889  0.3802667
 2.3090444  0.0777650  0.3787851
 2.3463118  0.0658378  0.3773035
 2.3831236  0.0526229  0.3758219
 2.4194353  0.0381379  0.3743403
 2.4552026  0.0224014  0.3728587
 2.4903831  0.0054336  0.3713771
 2.5249345 -0.0127436  0.3698955
 2.5588140 -0.0321064  0.3684139
 2.5919821 -0.0526311  0.3669324
 2.6243994 -0.0742913  0.3654508
 2.6560259 -0.0970591  0.3639691
 2.6868246 -0.1209061  0.3624876
 2.7167580 -0.1458023  0.3610060
 2.7457907 -0.1717160  0.3595244
 2.7738891 -0.1986157  0.3580428
 2.8010187 -0.2264665  0.3565612
 2.8271475 -0.2552340  0.3550796
 2.8522451 -0.2848829  0.3535980
 2.8762813 -0.3153760  0.3521164
 2.8992274 -0.3466740  0.3506348
 2.9210575 -0.3787400  0.3491532
 2.9417458 -0.4115340  0.3476716
 2.9612670 -0.4450133  0.3461900
 2.9796000 -0.4791389  0.3447084
 2.9967227 -0.5138673  0.3432268
 3.0126150 -0.5491557  0.3417452
 3.0272593 -0.5849613  0.3402636
 3.0406389 -0.6212397  0.3387820
 3.0527384 -0.6579459  0.3373004
 3.0635440 -0.6950344  0.3358189
 3.0730445 -0.7324615  0.3343373
 3.0812285 -0.7701784  0.3328557
 3.0880885 -0.8081419  0.3313741
 3.0936160 -0.8463033  0.3298925
 3.0978065 -0.8846170  0.3284109
 3.1006556 -0.9230360  0.3269293
 3.1021612 -0.9615130  0.3254477
 3.0730932 -3.0000000  0.2390759 ;
 ; ;
curd 4 lp3
       0.0 -0.1545082  0.4755284
 2.0000000 -0.1282582  0.3896701
 2.0304394 -0.1283314  0.3881716
 2.0608735 -0.1294677  0.3866731
 2.0912654 -0.1316668  0.3851746
 2.1215782 -0.1349272  0.3836761
 2.1517739 -0.1392460  0.3821776
 2.1818171 -0.1446192  0.3806791
 2.2116692 -0.1510409  0.3791806
 2.2412951 -0.1585048  0.3776821
 2.2706575 -0.1670029  0.3761836
 2.2997203 -0.1765256  0.3746851
 2.3284483 -0.1870626  0.3731866
 2.3568058 -0.1986020  0.3716882
 2.3847575 -0.2111308  0.3701897
 2.4122691 -0.2246345  0.3686911
 2.4393077 -0.2390983  0.3671927
 2.4658377 -0.2545049  0.3656942
 2.4918272 -0.2708366  0.3641957
 2.5172446 -0.2880747  0.3626972
 2.5420575 -0.3061990  0.3611987
 2.5662351 -0.3251882  0.3597002
 2.5897474 -0.3450204  0.3582017
 2.6125643 -0.3656714  0.3567033
 2.6346588 -0.3871180  0.3552047
 2.6560023 -0.4093342  0.3537062
 2.6765676 -0.4322935  0.3522077
 2.6963286 -0.4559688  0.3507092
 2.7152622 -0.4803331  0.3492108
 2.7333422 -0.5053557  0.3477122
 2.7505465 -0.5310068  0.3462138
 2.7668540 -0.5572580  0.3447153
 2.7822428 -0.5840752  0.3432168
 2.7966938 -0.6114276  0.3417183
 2.8101878 -0.6392824  0.3402198
 2.8227079 -0.6676056  0.3387213
 2.8342376 -0.6963633  0.3372228
 2.8447618 -0.7255208  0.3357244
 2.8542669 -0.7550442  0.3342259
 2.8627396 -0.7848953  0.3327273
 2.8701694 -0.8150410  0.3312289
 2.8765454 -0.8454421  0.3297304
 2.8818593 -0.8760636  0.3282319
 2.8861032 -0.9068677  0.3267334
 2.8892703 -0.9378168  0.3252349
 2.8913567 -0.9688739  0.3237364
 2.9186082 -3.0000000  0.2363796 ;
 ; ;
c
c CURVES 5 and 6 ARE THE SAME AS
c CURVES 3 and 4, EXCEPT THAT THE
c Z-COORDINATES OF THE CURVES WERE
c SET TO 0.0
c
curd 5 lp3
       0.0  0.1545092  0.0
 2.0000000  0.1252795  0.0
 2.0392537  0.1240842  0.0
 2.0784245  0.1215206  0.0
 2.1174638  0.1175931  0.0
 2.1563244  0.1123076  0.0
 2.1949599  0.1056720  0.0
 2.2333221  0.0976955  0.0
 2.2713661  0.0883889  0.0
 2.3090444  0.0777650  0.0
 2.3463118  0.0658378  0.0
 2.3831236  0.0526229  0.0
 2.4194353  0.0381379  0.0
 2.4552026  0.0224014  0.0
 2.4903831  0.0054336  0.0
 2.5249345 -0.0127436  0.0
 2.5588140 -0.0321064  0.0
 2.5919821 -0.0526311  0.0
 2.6243994 -0.0742913  0.0
 2.6560259 -0.0970591  0.0
 2.6868246 -0.1209061  0.0
 2.7167580 -0.1458023  0.0
 2.7457907 -0.1717160  0.0
 2.7738891 -0.1986157  0.0
 2.8010187 -0.2264665  0.0
 2.8271475 -0.2552340  0.0
 2.8522451 -0.2848829  0.0
 2.8762813 -0.3153760  0.0
 2.8992274 -0.3466740  0.0
 2.9210575 -0.3787400  0.0
 2.9417458 -0.4115340  0.0
 2.9612670 -0.4450133  0.0
 2.9796000 -0.4791389  0.0
 2.9967227 -0.5138673  0.0
 3.0126150 -0.5491557  0.0
 3.0272593 -0.5849613  0.0
 3.0406389 -0.6212397  0.0
 3.0527384 -0.6579459  0.0
 3.0635440 -0.6950344  0.0
 3.0730445 -0.7324615  0.0
 3.0812285 -0.7701784  0.0
 3.0880885 -0.8081419  0.0
 3.0936160 -0.8463033  0.0
 3.0978065 -0.8846170  0.0
 3.1006556 -0.9230360  0.0
 3.1021612 -0.9615130  0.0
 3.0730932 -3.0000000  0.0 ;
 ; ;
curd 6 lp3
       0.0 -0.1545082  0.0
 2.0000000 -0.1282582  0.0
 2.0304394 -0.1283314  0.0
 2.0608735 -0.1294677  0.0
 2.0912654 -0.1316668  0.0
 2.1215782 -0.1349272  0.0
 2.1517739 -0.1392460  0.0
 2.1818171 -0.1446192  0.0
 2.2116692 -0.1510409  0.0
 2.2412951 -0.1585048  0.0
 2.2706575 -0.1670029  0.0
 2.2997203 -0.1765256  0.0
 2.3284483 -0.1870626  0.0
 2.3568058 -0.1986020  0.0
 2.3847575 -0.2111308  0.0
 2.4122691 -0.2246345  0.0
 2.4393077 -0.2390983  0.0
 2.4658377 -0.2545049  0.0
 2.4918272 -0.2708366  0.0
 2.5172446 -0.2880747  0.0
 2.5420575 -0.3061990  0.0
 2.5662351 -0.3251882  0.0
 2.5897474 -0.3450204  0.0
 2.6125643 -0.3656714  0.0
 2.6346588 -0.3871180  0.0
 2.6560023 -0.4093342  0.0
 2.6765676 -0.4322935  0.0
 2.6963286 -0.4559688  0.0
 2.7152622 -0.4803331  0.0
 2.7333422 -0.5053557  0.0
 2.7505465 -0.5310068  0.0
 2.7668540 -0.5572580  0.0
 2.7822428 -0.5840752  0.0
 2.7966938 -0.6114276  0.0
 2.8101878 -0.6392824  0.0
 2.8227079 -0.6676056  0.0
 2.8342376 -0.6963633  0.0
 2.8447618 -0.7255208  0.0
 2.8542669 -0.7550442  0.0
 2.8627396 -0.7848953  0.0
 2.8701694 -0.8150410  0.0
 2.8765454 -0.8454421  0.0
 2.8818593 -0.8760636  0.0
 2.8861032 -0.9068677  0.0
 2.8892703 -0.9378168  0.0
 2.8913567 -0.9688739  0.0
 2.9186082 -3.0000000  0.0 ;
 ; ;
curd 7 lp3
       0.0  0.4493965  0.2191866
 2.0000000  0.3680272  0.1812427
 2.0476937  0.3657746  0.1805805
 2.0952308  0.3618614  0.1799182
 2.1425526  0.3562959  0.1792560
 2.1896014  0.3490884  0.1785938
 2.2363229  0.3402508  0.1779315
 2.2826567  0.3297979  0.1772693
 2.3285513  0.3177451  0.1766071
 2.3739483  0.3041110  0.1759448
 2.4187939  0.2889154  0.1752826
 2.4630361  0.2721799  0.1746203
 2.5066204  0.2539284  0.1739581
 2.5494952  0.2341865  0.1732959
 2.5916107  0.2129811  0.1726336
 2.6329174  0.1903407  0.1719714
 2.6733623  0.1662982  0.1713091
 2.7129028  0.1408833  0.1706469
 2.7514918  0.1141303  0.1699847
 2.7890818  0.0860759  0.1693224
 2.8256302  0.0567568  0.1686602
 2.8610947  0.0262110  0.1679979
 2.8954332 -0.0055205  0.1673357
 2.9286094 -0.0383993  0.1666735
 2.9605811 -0.0723790  0.1660112
 2.9913137 -0.1074177  0.1653490
 3.0207732 -0.1434713  0.1646868
 3.0489254 -0.1804930  0.1640245
 3.0757365 -0.2184319  0.1633623
 3.1011803 -0.2572452  0.1627000
 3.1252284 -0.2968830  0.1620378
 3.1478500 -0.3372892  0.1613756
 3.1690259 -0.3784198  0.1607133
 3.1887300 -0.4202192  0.1600511
 3.2069421 -0.4626354  0.1593889
 3.2236438 -0.5056167  0.1587266
 3.2388179 -0.5491086  0.1580644
 3.2524490 -0.5930568  0.1574021
 3.2645223 -0.6374043  0.1567399
 3.2750289 -0.6821021  0.1560777
 3.2839570 -0.7270865  0.1554154
 3.2913013 -0.7723106  0.1547532
 3.2970545 -0.8177121  0.1540909
 3.3012137 -0.8632382  0.1534287
 3.3037775 -0.9088329  0.1527665
 3.3047454 -0.9544390  0.1521042
 3.2227514 -3.0000000  0.1134980 ;
 ; ;
curd 8 lp3
       0.0 -0.4493970  0.2191855
 1.9999999 -0.3694009  0.1784260
 2.0220566 -0.3683898  0.1777147
 2.0441830 -0.3681515  0.1770033
 2.0663531 -0.3686898  0.1762919
 2.0885401 -0.3700076  0.1755805
 2.1107140 -0.3721063  0.1748691
 2.1328511 -0.3749872  0.1741578
 2.1549196 -0.3786494  0.1734464
 2.1768954 -0.3830925  0.1727350
 2.1987493 -0.3883141  0.1720236
 2.2204525 -0.3943109  0.1713122
 2.2419798 -0.4010791  0.1706008
 2.2633028 -0.4086136  0.1698895
 2.2843933 -0.4169081  0.1691781
 2.3052242 -0.4259551  0.1684667
 2.3257720 -0.4357488  0.1677553
 2.3460052 -0.4462778  0.1670440
 2.3658988 -0.4575325  0.1663326
 2.3854284 -0.4695031  0.1656212
 2.4045677 -0.4821775  0.1649098
 2.4232905 -0.4955426  0.1641984
 2.4415729 -0.5095856  0.1634871
 2.4593875 -0.5242895  0.1627757
 2.4767148 -0.5396426  0.1620643
 2.4935288 -0.5556264  0.1613529
 2.5098057 -0.5722229  0.1606415
 2.5255237 -0.5894148  0.1599302
 2.5406637 -0.6071869  0.1592188
 2.5552006 -0.6255141  0.1585074
 2.5691144 -0.6443765  0.1577960
 2.5823894 -0.6637591  0.1570846
 2.5950015 -0.6836327  0.1563733
 2.6069353 -0.7039788  0.1556619
 2.6181722 -0.7247736  0.1549505
 2.6286950 -0.7459919  0.1542391
 2.6384888 -0.7676097  0.1535278
 2.6475377 -0.7896021  0.1528164
 2.6558285 -0.8119459  0.1521050
 2.6633461 -0.8346087  0.1513936
 2.6700802 -0.8575719  0.1506822
 2.6760175 -0.8808000  0.1499709
 2.6811485 -0.9042715  0.1492595
 2.6854630 -0.9279557  0.1485481
 2.6889522 -0.9518238  0.1478367
 2.6916094 -0.9758488  0.1471253
 2.7734230 -3.0000000  0.1056544 ;
 ; ;
c
c Extract the Edge Curves of the elbow pipe.
c
 curd 9 sdedge 1.1
 curd 10 sdedge 1.3
c
c Make some ruled surfaces out of the curves
c
 sd 4 rule3d 3 5 ;
 sd 5 rule3d 4 6 ;
 sd 6 rule3d 7 8 ;
c
c Intersection of two pipes
c
curd 11 lp3
 2.8348172  0.0999734  0.0023044
 2.8348176  0.0999296  0.0037523
 2.8348441  0.0998648  0.0051991
 2.8348970  0.0997790  0.0066442
 2.8349757  0.0996725  0.0080866
 2.8350806  0.0995452  0.0095258
 2.8352103  0.0993975  0.0109609
 2.8353658  0.0992294  0.0123912
 2.8355470  0.0990410  0.0138160
 2.8357525  0.0988327  0.0152347
 2.8359141  0.0986032  0.0166557
 2.8360934  0.0983535  0.0180713
 2.8362975  0.0980844  0.0194799
 2.8365269  0.0977957  0.0208807
 2.8367801  0.0974880  0.0222734
 2.8370578  0.0971615  0.0236570
 2.8373594  0.0968164  0.0250312
 2.8376837  0.0964535  0.0263955
 2.8380313  0.0960728  0.0277492
 2.8383780  0.0956729  0.0290976
 2.8386998  0.0952525  0.0304459
 2.8390450  0.0948148  0.0317829
 2.8394127  0.0943602  0.0331082
 2.8398027  0.0938890  0.0344214
 2.8402143  0.0934020  0.0357220
 2.8406472  0.0928992  0.0370097
 2.8411007  0.0923814  0.0382841
 2.8415747  0.0918487  0.0395450
 2.8420687  0.0913016  0.0407921
 2.8425736  0.0907395  0.0420278
 2.8430450  0.0901553  0.0432667
 2.8435364  0.0895574  0.0444912
 2.8440471  0.0889461  0.0457010
 2.8445771  0.0883219  0.0468959
 2.8451252  0.0876853  0.0480759
 2.8456922  0.0870365  0.0492405
 2.8462758  0.0863762  0.0503900
 2.8468771  0.0857045  0.0515240
 2.8474946  0.0850221  0.0526425
 2.8480954  0.0843208  0.0537586
 2.8487034  0.0836069  0.0548625
 2.8492842  0.0828716  0.0559670
 2.8498745  0.0821240  0.0570583
 2.8504808  0.0813661  0.0581338
 2.8511014  0.0805986  0.0591937
 2.8517380  0.0798212  0.0602375
 2.8523884  0.0790351  0.0612656
 2.8530531  0.0782400  0.0622777
 2.8537316  0.0774365  0.0632739
 2.8544230  0.0766247  0.0642547
 2.8568521  0.0738288  0.0674485
 2.8593159  0.0709137  0.0705070
 2.8618884  0.0679203  0.0733951
 2.8645828  0.0648683  0.0761058
 2.8673868  0.0617669  0.0786438
 2.8702865  0.0586222  0.0810150
 2.8731995  0.0553948  0.0832552
 2.8762031  0.0521404  0.0853310
 2.8792882  0.0488647  0.0872482
 2.8823252  0.0454850  0.0890568
 2.8854136  0.0420755  0.0907175
 2.8885665  0.0386546  0.0922271
 2.8917780  0.0352264  0.0935901
 2.8950038  0.0317629  0.0948215
 2.8982835  0.0283021  0.0959115
 2.9016123  0.0248472  0.0968639
 2.9049845  0.0214012  0.0976831
 2.9083972  0.0179660  0.0983728
 2.9118462  0.0145443  0.0989366
 2.9152350  0.0110468  0.0993880
 2.9186244  0.0075360  0.0997157
 2.9220433  0.0040443  0.0999182
 2.9254885  0.0005735  0.0999983
 2.9289570 -0.0028743  0.0999587
 2.9324465 -0.0062975  0.0998015
 2.9359546 -0.0096946  0.0995290
 2.9394791 -0.0130640  0.0991430
 2.9430172 -0.0164038  0.0986454
 2.9465671 -0.0197128  0.0980378
 2.9500141 -0.0231022  0.0972948
 2.9534686 -0.0264566  0.0964367
 2.9569299 -0.0297727  0.0954651
 2.9603961 -0.0330487  0.0943810
 2.9638648 -0.0362828  0.0931856
 2.9673109 -0.0394947  0.0918704
 2.9707432 -0.0426708  0.0904389
 2.9741697 -0.0458011  0.0888946
 2.9775872 -0.0488829  0.0872380
 2.9809937 -0.0519138  0.0854690
 2.9842880 -0.0549694  0.0835367
 2.9875522 -0.0579746  0.0814797
 2.9907830 -0.0609272  0.0792961
 2.9939442 -0.0638436  0.0769674
 2.9970765 -0.0666892  0.0745154
 3.0001767 -0.0694598  0.0719398
 3.0032406 -0.0721511  0.0692402
 3.0062485 -0.0747676  0.0664064
 3.0091376 -0.0773294  0.0634047
 3.0119720 -0.0797948  0.0602726
 3.0127864 -0.0804945  0.0593349
 3.0135961 -0.0811851  0.0583863
 3.0144002 -0.0818669  0.0574266
 3.0151987 -0.0825393  0.0564558
 3.0159917 -0.0832026  0.0554737
 3.0167782 -0.0838560  0.0544809
 3.0175219 -0.0845123  0.0534571
 3.0182285 -0.0851677  0.0524067
 3.0189281 -0.0858115  0.0513457
 3.0196209 -0.0864450  0.0502718
 3.0203061 -0.0870667  0.0491872
 3.0209842 -0.0876769  0.0480912
 3.0216539 -0.0882750  0.0469843
 3.0223160 -0.0888612  0.0458661
 3.0229697 -0.0894350  0.0447368
 3.0236154 -0.0899964  0.0435965
 3.0242524 -0.0905451  0.0424452
 3.0248809 -0.0910810  0.0412827
 3.0254612 -0.0916105  0.0400938
 3.0260262 -0.0921274  0.0388914
 3.0265813 -0.0926302  0.0376783
 3.0271256 -0.0931183  0.0364552
 3.0276594 -0.0935922  0.0352206
 3.0281825 -0.0940510  0.0339764
 3.0286942 -0.0944947  0.0327221
 3.0291948 -0.0949231  0.0314578
 3.0296841 -0.0953358  0.0301840
 3.0301614 -0.0957327  0.0289007
 3.0306029 -0.0961156  0.0276005
 3.0310020 -0.0964843  0.0262826
 3.0313883 -0.0968360  0.0249560
 3.0317607 -0.0971702  0.0236211
 3.0321188 -0.0974868  0.0222782
 3.0324636 -0.0977856  0.0209276
 3.0327940 -0.0980664  0.0195696
 3.0331106 -0.0983290  0.0182047
 3.0334125 -0.0985731  0.0168330
 3.0336995 -0.0987985  0.0154549
 3.0339222 -0.0990064  0.0140623
 3.0341187 -0.0991950  0.0126630
 3.0342994 -0.0993642  0.0112591
 3.0344639 -0.0995136  0.0098509
 3.0346129 -0.0996433  0.0084392
 3.0347457 -0.0997530  0.0070240
 3.0348620 -0.0998427  0.0056061
 3.0349627 -0.0999124  0.0041858
 3.0350466 -0.0999619  0.0027635
 3.0351138 -0.0999910  0.0013399
 3.0351653 -0.1000001 -0.0000848 ;
 ; ;
para xcv [0.5*(2.8348172+3.0351653)]
     ycv [0.5*(0.0999734-0.1000001)]
     xl  [2.8348172-3.0351653]
     yl  [0.0999734+0.1000001]
     radcv [0.5*sqrt(%xl*%xl+%yl*%yl)];
c
c Extra Cylinder
c
 ld 1 lep 
   [%radcv] [0.1] 
   [%xcv] [%ycv] 
   0 180
   0;
 sd 7 cp 1 
    v [-%xcv] [-%ycv] 0 
    rz -45 
    v  [%xcv]  [%ycv] 0 ;
c
c Intersection of new cylinder and elbow pipe
c
curd 12 lp3                                                                     
 2.2785516 -0.4562924        0.0
 2.2785859 -0.4562824  0.0014080
 2.2786472 -0.4562838  0.0028151
 2.2787347 -0.4562960  0.0042209
 2.2788482 -0.4563194  0.0056246
 2.2789874 -0.4563538  0.0070258
 2.2791595 -0.4564019  0.0084229
 2.2793586 -0.4564614  0.0098159
 2.2795830 -0.4565318  0.0112047
 2.2798548 -0.4565899  0.0125855
 2.2801604 -0.4566479  0.0139592
 2.2804976 -0.4567196  0.0153249
 2.2808592 -0.4568019  0.0166836
 2.2812443 -0.4568944  0.0180354
 2.2816517 -0.4569967  0.0193803
 2.2820830 -0.4571097  0.0207158
 2.2825432 -0.4572353  0.0220411
 2.2830248 -0.4573701  0.0233577
 2.2835271 -0.4575143  0.0246657
 2.2840691 -0.4576457  0.0259595
 2.2846484 -0.4577754  0.0272364
 2.2852483 -0.4579146  0.0285032
 2.2858663 -0.4580624  0.0297602
 2.2865019 -0.4582183  0.0310074
 2.2871609 -0.4583855  0.0322409
 2.2878389 -0.4585616  0.0334628
 2.2885189 -0.4587641  0.0346803
 2.2892132 -0.4589755  0.0358869
 2.2899299 -0.4591987  0.0370791
 2.2906630 -0.4594305  0.0382613
 2.2914252 -0.4596464  0.0394230
 2.2922111 -0.4598607  0.0405721
 2.2930162 -0.4600860  0.0417057
 2.2938333 -0.4603186  0.0428292
 2.2946625 -0.4605573  0.0439425
 2.2955089 -0.4608065  0.0450404
 2.2963684 -0.4610632  0.0461262
 2.2972388 -0.4613264  0.0472026
 2.2981224 -0.4615973  0.0482648
 2.2990208 -0.4618771  0.0493134
 2.2999282 -0.4621625  0.0503517
 2.3008471 -0.4624543  0.0513785
 2.3017888 -0.4627424  0.0523854
 2.3027489 -0.4630189  0.0533779
 2.3037186 -0.4633017  0.0543600
 2.3047013 -0.4635932  0.0553254
 2.3056917 -0.4638898  0.0562821
 2.3066907 -0.4641921  0.0572281
 2.3077018 -0.4645028  0.0581580
 2.3087187 -0.4648178  0.0590793
 2.3124127 -0.4661166  0.0623401
 2.3162115 -0.4674895  0.0654518
 2.3201418 -0.4688541  0.0683863
 2.3241553 -0.4702914  0.0711771
 2.3282402 -0.4717956  0.0738272
 2.3323431 -0.4734458  0.0763544
 2.3364928 -0.4751823  0.0787486
 2.3407192 -0.4769284  0.0809933
 2.3449907 -0.4787342  0.0831049
 2.3493009 -0.4805956  0.0850856
 2.3535843 -0.4826255  0.0869526
 2.3578835 -0.4847334  0.0886928
 2.3622091 -0.4868920  0.0903048
 2.3665776 -0.4890554  0.0917846
 2.3709493 -0.4912915  0.0931415
 2.3752701 -0.4936888  0.0943829
 2.3796000 -0.4961314  0.0954987
 2.3839359 -0.4986172  0.0964897
 2.3882747 -0.5011439  0.0973565
 2.3925433 -0.5038238  0.0981041
 2.3967857 -0.5065749  0.0987278
 2.4010227 -0.5093621  0.0992264
 2.4052482 -0.5121820  0.0995999
 2.4094253 -0.5150907  0.0998492
 2.4135208 -0.5181174  0.0999720
 2.4175982 -0.5211720  0.0999679
 2.4216549 -0.5242527  0.0998366
 2.4256849 -0.5273585  0.0995775
 2.4295778 -0.5306228  0.0991885
 2.4334402 -0.5339062  0.0986694
 2.4372673 -0.5372047  0.0980198
 2.4410586 -0.5405181  0.0972383
 2.4447351 -0.5439236  0.0963231
 2.4483223 -0.5473866  0.0952733
 2.4518619 -0.5508547  0.0940882
 2.4553504 -0.5543256  0.0927662
 2.4587681 -0.5578103  0.0913045
 2.4620161 -0.5613930  0.0897018
 2.4652076 -0.5649604  0.0879575
 2.4683752 -0.5684786  0.0860687
 2.4714742 -0.5719759  0.0840351
 2.4744439 -0.5754929  0.0818574
 2.4772658 -0.5790381  0.0795283
 2.4800048 -0.5825477  0.0770496
 2.4826722 -0.5860009  0.0744184
 2.4852972 -0.5893552  0.0716239
 2.4877815 -0.5926855  0.0686739
 2.4900918 -0.5960047  0.0655757
 2.4922843 -0.5992434  0.0623101
 2.4929173 -0.6001475  0.0613372
 2.4935451 -0.6010384  0.0603484
 2.4941607 -0.6019192  0.0593448
 2.4947677 -0.6027936  0.0583288
 2.4953656 -0.6036611  0.0573009
 2.4959481 -0.6045153  0.0562564
 2.4965205 -0.6053621  0.0551984
 2.4970832 -0.6062007  0.0541288
 2.4976344 -0.6070301  0.0530460
 2.4981704 -0.6078467  0.0519461
 2.4986954 -0.6086543  0.0508344
 2.4992094 -0.6094525  0.0497106
 2.4997122 -0.6102383  0.0485724
 2.5002036 -0.6110063  0.0474180
 2.5006833 -0.6117632  0.0462519
 2.5011516 -0.6125093  0.0450737
 2.5016069 -0.6132426  0.0438826
 2.5020466 -0.6139612  0.0426719
 2.5024714 -0.6146641  0.0414556
 2.5028844 -0.6153554  0.0402251
 2.5032849 -0.6160347  0.0389805
 2.5036659 -0.6166942  0.0377248
 2.5040331 -0.6173400  0.0364550
 2.5044146 -0.6179454  0.0351699
 2.5047860 -0.6185319  0.0338729
 2.5051427 -0.6191027  0.0325648
 2.5054798 -0.6196523  0.0312425
 2.5058012 -0.6201858  0.0299094
 2.5061073 -0.6207027  0.0285653
 2.5063972 -0.6212016  0.0272138
 2.5066707 -0.6216838  0.0258509
 2.5069232 -0.6221428  0.0244766
 2.5071666 -0.6225760  0.0230907
 2.5074196 -0.6229641  0.0216960
 2.5076559 -0.6233337  0.0202914
 2.5078745 -0.6236834  0.0188795
 2.5080738 -0.6240113  0.0174595
 2.5082517 -0.6243155  0.0160313
 2.5084114 -0.6245992  0.0145967
 2.5085526 -0.6248622  0.0131562
 2.5086751 -0.6251044  0.0117092
 2.5087852 -0.6253183  0.0102592
 2.5088999 -0.6254847  0.0088017
 2.5089927 -0.6256254  0.0073407
 2.5090666 -0.6257446  0.0058764
 2.5091205 -0.6258414  0.0044095
 2.5091555 -0.6259162  0.0029407
 2.5091710 -0.6259687  0.0014707
 2.5091670 -0.6259987 -1.926E-10 ;
 ; ;      
sd 7 rule3d 11 12;
curd 13 lp3                                                                     
 3.0011978 -0.0703569  0.0710399
 2.9796419 -0.0919053  0.0711280
 2.9580865 -0.1134538  0.0712160
 2.9365306 -0.1350022  0.0713041
 2.9149747 -0.1565507  0.0713921
 2.8934193 -0.1780991  0.0714802
 2.8718636 -0.1996475  0.0715683
 2.8503079 -0.2211960  0.0716563
 2.8287523 -0.2427444  0.0717444
 2.8071964 -0.2642928  0.0718324
 2.7856407 -0.2858413  0.0719205
 2.7640853 -0.3073897  0.0720085
 2.7425294 -0.3289382  0.0720966
 2.7209735 -0.3504866  0.0721846
 2.6994178 -0.3720351  0.0722727
 2.6778622 -0.3935835  0.0723607
 2.6563063 -0.4151320  0.0724488
 2.6347506 -0.4366804  0.0725369
 2.6131949 -0.4582289  0.0726249
 2.5916393 -0.4797773  0.0727130
 2.5700836 -0.5013258  0.0728010
 2.5485277 -0.5228742  0.0728891
 2.5269721 -0.5444227  0.0729771
 2.5054164 -0.5659711  0.0730652
 2.4838607 -0.5875195  0.0731532 ;
 ; ;             
curd 14 lp3                                                                     
 2.8617530  0.0680779  0.0732431
 2.8392973  0.0456658  0.0731182
 2.8168416  0.0232537  0.0729934
 2.7943859  0.0008416  0.0728685
 2.7719302 -0.0215705  0.0727437
 2.7494748 -0.0439826  0.0726188
 2.7270188 -0.0663947  0.0724940
 2.7045634 -0.0888067  0.0723692
 2.6821077 -0.1112188  0.0722443
 2.6596522 -0.1336309  0.0721195
 2.6371965 -0.1560430  0.0719946
 2.6147408 -0.1784551  0.0718698
 2.5922852 -0.2008672  0.0717449
 2.5698295 -0.2232793  0.0716201
 2.5473738 -0.2456914  0.0714953
 2.5249181 -0.2681035  0.0713704
 2.5024624 -0.2905156  0.0712456
 2.4800067 -0.3129277  0.0711207
 2.4575512 -0.3353398  0.0709959
 2.4350955 -0.3577518  0.0708710
 2.4126399 -0.3801640  0.0707462
 2.3901842 -0.4025761  0.0706214
 2.3677287 -0.4249882  0.0704965
 2.3452730 -0.4474003  0.0703717
 2.3228173 -0.4698123  0.0702468 ;
 ; ;             
