{
********************************************************************************
********************************************************************************
*****                                                                      *****
*****     This is the geometry definitions file for the Dynamic Brazilian  *****
*****  Test Example.                                                       *****
*****  Please see the ReadME.txt file for more details.                    *****
*****     All the files in this sub-directory (folder) were initially      *****
*****  provided by                                                         *****
*****                       L. Schwer                                      *****
*****  and we gratefully acknowledge his efforts in preparing this         *****
*****  example.                                                            *****
*****                                                                      *****
*****                              XYZ Scientific Applications, Inc.       *****
*****                              October 16, 2000                        *****
*****                                                                      *****
********************************************************************************
********************************************************************************
}
c -----------------------------------------------------------------
c
c           Model of Dynamic Brazilian Tests on Concrete
c
c                     L Schwer  September 2000
c
c -----------------------------------------------------------------
c
c -----------------------------------------------------------------
c
c Change Notes:
c
c 21 Jul - add non-reflecting boundary to transmitted bar (nri)
c        - additional length for incident bar
c        - element print block output
c
c 22 Jul - correct element print blocks (epb)
c
c 11 Aug - add striker bar
c
c 13 Aug - lengthen modeled portions of incident & transmission bars
c          to include distance from end to strain gages (40 inches)
c          and a 16 inch run-up section near strain gage locations.
c
c 20 Aug - add sliding-with-voids interface between striker and
c          incident bars (%strikeri)
c
c 25 Aug - add option for %strikeri interface
c
c -----------------------------------------------------------------
c
c  units are
c                    length -> millimeters  = 10^-3 m
c                    time   -> milliseconds = 10^-3 s
c                    mass   -> gram         = 10^-3 kg
c                    Force  -> m*a = g*(mm/ms^2) 
c                                  = kg-m/s^2 = N 
c                  pressure -> F/A = N/mm^2 = 10^6 N/m^2 = MPa  
c
c -----------------------------------------------------------------
c
 parameter cyfaci [1/2.3] c factor for fitting grids in cylinders
           cyfaco [1.9] ; c factor for fitting grids on cylinders
c
c -----------------------------------------------------------------
c
c  geometry & symmetry
c           striker bar 25.7 inch x 2 inch dia
c           incident bar 12 feet x 2 inch dia
c           transmiter bar 11 feet x 2 inch dia
c           specimen 2 inch x 2 inch dia
c           bearing strip  0.25 inch x 0.25 inch x 2 inch
c           distance to strain gages 40 inch
  parameter
             coninmm   [25.4]        c convert inch to millimeter
             sbarlen   [25.7*%coninmm]
             ibarlen   [12*12*%coninmm]
             tbarlen   [11*12*%coninmm]
             speclen   [2*%coninmm]
             bearlen   [0.25*%coninmm]
             strainlen [40.0*%coninmm]    c distance to strain gages
             runuplen  [16.0*%coninmm]    c run-up to strain gages
             bardia    [2*%coninmm]
c  mesh spacing
         bmseqj     3                      c mseq j
         barney    [(5 - 1)*(%bmseqj + 1)] c number of elements (5 indices)
         bardy     [%bardia/%barney]       c y-distance
         bardx     [2*%bardy]              c x-distance 2:1 aspect
         smseqj     9
       ;
c
c -----------------------------------------------------------------
c
c   ...  incident bar  ...
c
 parameter barlen [%strainlen + %runuplen] ;
c
block 1 2 3 4  ; 1 2 3 4 5 ; 1 2 3 4 5 ;
c x-coors
[-%barlen]   [-%barlen + %runuplen]
[-%barlen + %runuplen + %bardx] 0.0
c y-coors
[-%cyfaci*%bardia/2] [-%cyfaci*%bardia/2] 0.0
[ %cyfaci*%bardia/2] [ %cyfaci*%bardia/2] 
c z-coors
[-%cyfaci*%bardia/2] [-%cyfaci*%bardia/2] 0.0
[ %cyfaci*%bardia/2] [ %cyfaci*%bardia/2] 
c
 mseq i [(%runuplen/%bardx) - 1] 
        0 [((%barlen - %runuplen - %bardx)/%bardx) - 1] 
 mseq j %bmseqj %bmseqj %bmseqj %bmseqj
 mseq k %bmseqj %bmseqj %bmseqj %bmseqj
c
dei ; 1 2 0 4 5 ; 1 2 0 4 5 ;  c four corners
c
c
c half or quarter symmetry model
 if (%hqsymm .ne. 0) then
  dei ; ; 3 5 ;   c half z-symmetry
   if (%hqsymm .eq. 4) then
    dei ; 1 3 ; ;   c quarter yz-symmetry
   endif
 endif                    c symmetry model
c
c
sfi ; -1 0 -5 ; 2 4 ; xcy [%bardia/2] ;
sfi ; 2 4 ; -1 0 -5 ; xcy [%bardia/2] ;
c
c
c apply pressure load to left end of incident bar
  if (%vstriker .eq. 0.0) then
   pri -1 ; ; ;  %loadcurve -1.0
  endif
c
c contact surfaces on right & left ends
   sii -4 ; ; ;  %barbear m
c optional striker inface
  if (%strikeri .ne. 0.0) then
c  omit striker surface if pressure loading 
    if (%vstriker .ne. 0.0) then
     sii -1 ; ; ;  %strikeri m
    endif
  endif
c
c element print blocks
   epb 2 3 2  3 4 3        c strain gage location
c
c
 lct 1 mx [-%bardia/2 - %bearlen] ; lrep 1 ;
c
mate %ibarmat
c
endpart
c
c
c   ...  striker bar  ...
c
c
block 1 2 3 ; 1 2 3 4 5 ; 1 2 3 4 5 ;
c x-coors
[-%sbarlen] [-%bardx] 0.0 
c y-coors
[-%cyfaci*%bardia/2] [-%cyfaci*%bardia/2] 0.0
[ %cyfaci*%bardia/2] [ %cyfaci*%bardia/2] 
c z-coors
[-%cyfaci*%bardia/2] [-%cyfaci*%bardia/2] 0.0
[ %cyfaci*%bardia/2] [ %cyfaci*%bardia/2] 
c
 mseq i  [(%sbarlen/%bardx) - 1] 0
 mseq j %bmseqj %bmseqj %bmseqj %bmseqj
 mseq k %bmseqj %bmseqj %bmseqj %bmseqj
c
dei ; 1 2 0 4 5 ; 1 2 0 4 5 ;  c four corners
c
c
c half or quarter symmetry model
 if (%hqsymm .ne. 0) then
  dei ; ; 3 5 ;   c half z-symmetry
   if (%hqsymm .eq. 4) then
    dei ; 1 3 ; ;   c quarter yz-symmetry
   endif
 endif                    c symmetry model
c
c
 sfi ; -1 0 -5 ; 2 4 ; xcy [%bardia/2] ;
 sfi ; 2 4 ; -1 0 -5 ; xcy [%bardia/2] ;
c
c
c apply inital velocity to striker bar
  if (%vstriker .ne. 0.0) then
   velocity %vstriker 0.0 0.0
  endif
c
c optional striker inface
  if (%strikeri .ne. 0.0) then
c  contact surface on right end
    sii -3 ; ; ;  %strikeri s
  endif
c
c element print blocks
   epb 2 3 2  3 4 3        c right end of striker
c
 lct 1 mx [-%barlen - %bardia/2 - %bearlen] ; lrep 1 ;
c
c omit striker if pressure loading is used
  if (%vstriker .ne. 0.0) then
    mate %sbarmat
  else
    mate %mate0
  endif

c
endpart
c
c
c   ...  tranmitted bar  ...
c
c parameter barlen [%tbarlen/4] ;
c
block 1 2 3 4  ; 1 2 3 4 5 ; 1 2 3 4 5 ;
c x-coors
 0.0 [%barlen - %runuplen - %bardx]
 [%barlen - %runuplen] [%barlen]   
c y-coors
[-%cyfaci*%bardia/2] [-%cyfaci*%bardia/2] 0.0
[ %cyfaci*%bardia/2] [ %cyfaci*%bardia/2] 
c z-coors
[-%cyfaci*%bardia/2] [-%cyfaci*%bardia/2] 0.0
[ %cyfaci*%bardia/2] [ %cyfaci*%bardia/2] 
c
 mseq i [((%barlen - %runuplen - %bardx)/%bardx) - 1] 
         0 [(%runuplen/%bardx) - 1] 
 mseq j %bmseqj %bmseqj %bmseqj %bmseqj
 mseq k %bmseqj %bmseqj %bmseqj %bmseqj
c
dei ; 1 2 0 4 5 ; 1 2 0 4 5 ;  c four corners
c
c
c half or quarter symmetry model
 if (%hqsymm .ne. 0) then
  dei ; ; 3 5 ;   c half z-symmetry
   if (%hqsymm .eq. 4) then
    dei ; 1 3 ; ;   c quarter yz-symmetry
   endif
 endif                    c symmetry model
c
sfi ; -1 0 -5 ; 2 4 ; xcy [%bardia/2] ;
sfi ; 2 4 ; -1 0 -5 ; xcy [%bardia/2] ;
c
c contact surface on left end
   sii -1 ; ; ;  %barbear m
c
c non-reflecting surface on right end
   nri -4 ; ; ;
c
c element print blocks
   epb 2 3 2  3 4 3        c strain gage location
c
c
 lct 1 mx [%bardia/2 + %bearlen] ; lrep 1 ;
c
mate %tbarmat
c
endpart
c
c
c      ...  specimen  ...
c
block 1 2 3 ; 1 2 3 4 5 ; 1 2 3 4 5 ;
c x-coors
 [-%bardia/2] 0.0 [%bardia/2]
c y-coors
[-%cyfaci*%bardia/2] [-%cyfaci*%bardia/2] 0.0
[ %cyfaci*%bardia/2] [ %cyfaci*%bardia/2] 
c z-coors
[-%cyfaci*%bardia/2] [-%cyfaci*%bardia/2] 0.0
[ %cyfaci*%bardia/2] [ %cyfaci*%bardia/2] 
c
 mseq i [2*%smseqj + 1] [2*%smseqj + 1]
 mseq j %smseqj %smseqj %smseqj %smseqj
 mseq k %smseqj %smseqj %smseqj %smseqj
c
dei ; 1 2 0 4 5 ; 1 2 0 4 5 ;  c four corners
c
c half or quarter symmetry model
 if (%hqsymm .ne. 0) then
  dei 1 2 ; ; ;   c half z-symmetry
   if (%hqsymm .eq. 4) then
    dei ; 1 3 ; ;   c quarter yz-symmetry
   endif
 endif                    c symmetry model
c
sfi ; -1 0 -5 ; 2 4 ; xcy [%bardia/2] ;
sfi ; 2 4 ; -1 0 -5 ; xcy [%bardia/2] ;
c
c contact surfaces 
   sii ; 2 4 ; -1 0 -5 ;  %specbear m
c
c element print block
c  epb 2 3 3 3 4 4        c upper right center core quadrant
c
 lct 1 ry 90 ; lrep 1 ;
c
mate %specmat
c
endpart
c
c
c   ...  bearing strip  ...
c
block 1 2 3 ; 1 2 3 ; 1 2 3 ;
c x-coors
 [%bardia/2 + %bearlen] [%bardia/2 + %bearlen] [%bardia/2 + %bearlen]
c y-coors
 [-%bearlen/2] 0.0 [ %bearlen/2]
c z-coors
 [-%bardia/2] 0.0 [ %bardia/2]
c
 mseq i 1 1
 mseq j 1 1 
 mseq k [2*%bmseqj + 1] [2*%bmseqj + 1]
c
c half or quarter symmetry model
 if (%hqsymm .ne. 0) then
  dei ; ; 2 3 ;   c half z-symmetry
   if (%hqsymm .eq. 4) then
    dei ; 1 2 ; ;   c quarter yz-symmetry
   endif
 endif                    c symmetry model
c
c
sfi -1 ; ; ; zcy [%bardia/2] ;              c onto specimen
sfi -2 ; ; ; zcy [%bardia/2 + %bearlen/2] ; c mid-plane
sfi ; -1 ; ; xzplan my [-%bearlen/2] ;      c bottom plane
sfi ; -3 ; ; xzplan my [ %bearlen/2] ;      c top plane
c
c contact surfaces
   sii -1 ; ; ;  %specbear s
   sii -3 ; ; ;  %barbear  s
c
c element print block
   epb 2 2 1 3 3 2        c upper right quadrant
c
c
 lct 1 ryz ; lrep 0 1 ;
c
mate %bearmat
c
endpart
c
