/***************************************************************************
* XMLParser.java
*
* (C) Copyright 2009 SafeNet, Inc. All rights reserved.
*
*
* Purpose     : Used to parse the xml file.
*
* Refer to the ReadMe.pdf for customize details of Sentinel License Monitor.
*
****************************************************************************/

import java.util.*;

class XMLParser{
  /**
  * Method to parse the XML Buffer and return the vector contains all values find for the given tag.
  */
  public Vector getXMLTagValue(String xml, String tag) throws Exception
  {
    String xmlString = new String(xml);
    Vector vale = new Vector();
    String beginTagToSearch = "<" + tag + ">";
    String endTagToSearch = "</" + tag + ">";

    // Look for the first occurrence of begin tag
    //uses the toLowerCase() function for case in-sensitive comparison
    int index = xmlString.toLowerCase().indexOf(beginTagToSearch.toLowerCase());

    while(index != -1)
    {
      // Look for end tag
      // DOES NOT HANDLE <section Blah />
      int lastIndex = xmlString.toLowerCase().indexOf(endTagToSearch.toLowerCase());

      // Make sure there is no error
      if((lastIndex == -1) || (lastIndex < index))
        throw new Exception("Parse Error");

      // extract the substring
      String subs = xmlString.substring((index + beginTagToSearch.length()), lastIndex) ;
      // Add it to our list of tag values
      vale.addElement(subs);

      // Try it again. Narrow down to the part of string which is not processed yet.
      try
      {
        xmlString = xmlString.substring(lastIndex + endTagToSearch.length());
      }
      catch(Exception e)
      {
        xmlString = "";
      }

      // Start over again by searching the first occurrence of the begin tag
      // to continue the loop.

      index = xmlString.toLowerCase().indexOf(beginTagToSearch.toLowerCase());
    }
    return vale;
  }
}